package net.gdface.codegen.webclient;

import java.io.File;
import java.util.HashSet;
import java.util.Set;

import net.gdface.codegen.generator.GeneratorConfiguration;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class KSoapStubConfiguration extends GeneratorConfiguration implements WebClientConstants {
	private File wsdlLocatoin;
	private final Set<String> independentSchemas=new HashSet<String>();
	private Class<?> serviceClass;
	private String serviceName;
	public KSoapStubConfiguration() {
		defaultValue.setProperty(INDEPENDENT_SEHEMA_OPTION_LONG, "");
		defaultValue.setProperty(SERVICE_NAME_OPTION_LONG, "");
	}

	@Override
	public void loadConfig(Options options, CommandLine cmd) throws ParseException {
		super.loadConfig(options, cmd);
		serviceClass = getProperty(WebClientConstants.CLASSNAME_OPTION_LONG);
		serviceName = getProperty(SERVICE_NAME_OPTION_LONG);
		if(serviceName.isEmpty())//如果没有指定，则使用serviceClass类名做服务名
			serviceName=serviceClass.getSimpleName();
		wsdlLocatoin = getProperty(WSDL_LOCATION_URI_OPTION);
		for (String schema : ((String)getProperty(INDEPENDENT_SEHEMA_OPTION_LONG)).split("[,;=]"))
			if (!(schema=schema.trim().toUpperCase()).isEmpty())
				independentSchemas.add(schema);

	}
	/**
	 * @return wsdlLocatoin
	 */
	public File getWsdlLocatoin() {
		return wsdlLocatoin;
	}

	/**
	 * @return independentSchemas
	 */
	public Set<String> getIndependentSchemas() {
		return independentSchemas;
	}

	/**
	 * @return serviceClass
	 */
	public Class<?> getServiceClass() {
		return serviceClass;
	}

	/**
	 * @return serviceName
	 */
	public String getServiceName() {
		return serviceName;
	}
}
