package net.gdface.codegen.webclient;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPCClient<T> extends WebClient<T> implements WebClientConstants {
	private static final Logger logger = LoggerFactory.getLogger(RPCClient.class);
	private final String namespaceURI;

	public RPCClient(Class<T> interfaceClass, Class<? extends T> refClass, Class<?> serviceClass) {
		super(interfaceClass, refClass, serviceClass);
		namespaceURI = NAMESPACEGENERATOR.namespaceFromPackageName(serviceClass.getPackage().getName()).toString();
		getImportedList().put("AxisFault", org.apache.axis2.AxisFault.class);
	}

	/**
	 * @return namespaceURI
	 */
	public String getNamespaceURI() {
		return namespaceURI;
	}

	@Override
	public boolean compile() {
		boolean compileOk = false;
		try {
			if (super.compile()) {
				method2PortMap = createMethod2PortMapMap();
				// addImportedClassFromMethods(method2PortMap.values());
				compileOk = true;
			}
		} catch (NoSuchMethodException e) {
			logger.error(e.toString());
		}
		return compileOk;
	}

}
