package net.gdface.codegen.webclient;

import org.apache.commons.cli.Options;

import net.gdface.cli.Context;
import net.gdface.codegen.generator.GeneratorConfiguration;

public class StubClientGenerator extends WebClientGenerator {
	private final StubClientOptions options = StubClientOptions.getInstance();
	protected StubClientConfiguration config = new StubClientConfiguration();

	public StubClientGenerator() {
		config = new StubClientConfiguration();
	}

	public static void main(String[] args) {
		new StubClientGenerator().parseCommandLine(args).initEngine().generate();
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	protected Context createEngineContext() {
		Context context = super.createEngineContext();
		StubClient newSourceInfo = new StubClient(config.getInterfaceClass(), config.getRefClass(),
				config.getServiceClass(), config.getStubPackage());
		if (!newSourceInfo.compile())
			System.exit(1);
		context.setProperty(SOURCE_INFO, newSourceInfo);
		return context;
	}

	@Override
	protected Options getOptions() {
		return options.getOptions();
	}

	@Override
	protected GeneratorConfiguration getGeneratorConfiguration() {
		return config;
	}

}
