package net.gdface.codegen.webclient;

import org.apache.commons.cli.Options;

import net.gdface.cli.Context;
import net.gdface.codegen.generator.Generator;
import net.gdface.codegen.generator.GeneratorConfiguration;
import net.gdface.codegen.wsdl.ExtGeneratorUtils;

/**
 * @author guyadong
 *
 */
public class WebClientGenerator extends Generator {
	public static void main(String[] args) {
		new WebClientGenerator().parseCommandLine(args).initEngine().generate();
	}

	private final WebClientOptions options = WebClientOptions.getInstance();

	protected WebClientConfiguration config = new WebClientConfiguration();

	public WebClientGenerator() {
	}

	@Override
	protected GeneratorConfiguration getGeneratorConfiguration() {
		return this.config;
	}

	@Override
	protected Options getOptions() {
		return options.getOptions();
	}

	@Override
	protected Context createEngineContext() {
		Context context = super.createEngineContext();
		// 修改公共内置对象，使用ExtGeneratorUtils替换GeneratorUtils,以提供 isBase64Binary 方法
		context.setProperty(GENERATOR_TOOL, ExtGeneratorUtils.class);
		return context;
	}

}
