package net.gdface.codegen.webclient;

import org.apache.commons.cli.Options;

import net.gdface.cli.Context;
import net.gdface.codegen.generator.CodeWriter;
import net.gdface.codegen.generator.CxxCodeWriter;
import net.gdface.codegen.generator.GeneratorConfiguration;

public class GSoapClientGenerator extends WebClientGenerator {
	private final GSoapClientOptions options = GSoapClientOptions.getInstance();
	protected GSoapClientConfiguration config;

	public GSoapClientGenerator() {
		config = new GSoapClientConfiguration();
	}

	public static void main(String[] args) {
		new GSoapClientGenerator().parseCommandLine(args).initEngine().generate();
	}


	@Override
	protected CodeWriter getCodeWriter() {
		return new CxxCodeWriter(config.getOutputLocation());
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	protected Context createEngineContext() {
		Context context = super.createEngineContext();
		GSoapClient newSourceInfo = new GSoapClient(config.getInterfaceClass(), config.getRefClass(),
				config.getServiceClass(), config.getServiceName(), config.getStubFolder(), config.getStubPrefix());
		if (!newSourceInfo.compile())
			System.exit(1);
		context.setProperty(SOURCE_INFO, newSourceInfo);
		return context;
	}

	@Override
	protected Options getOptions() {
		return options.getOptions();
	}

	@Override
	protected GeneratorConfiguration getGeneratorConfiguration() {
		return config;
	}

}
