package net.gdface.codegen.webclient;

import java.io.File;

import net.gdface.codegen.generator.GeneratorConfiguration;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class GSoapStubConfiguration extends GeneratorConfiguration implements GSoapConstants,WebClientConstants {
	private File stubFolder;
	private String stubPrefix;
	private Class<?> serviceClass;
	public GSoapStubConfiguration() {
		// stubPrefix默认值为空
		defaultValue.setProperty(GSOAP_STUBPREFIX_OPTION_LONG, "");
	}

	@Override
	public void loadConfig(Options options, CommandLine cmd) throws ParseException {
		super.loadConfig(options, cmd);
		stubFolder = getProperty(GSOAP_STUB_FOLDER_OPTION_LONG);
		serviceClass = getProperty(WebClientConstants.CLASSNAME_OPTION_LONG);
		stubPrefix = getProperty(GSOAP_STUBPREFIX_OPTION_LONG);
	}

	/**
	 * @return stubFolder
	 */
	public File getStubFolder() {
		return stubFolder;
	}

	/**
	 * @return stubPrefix
	 */
	public String getStubPrefix() {
		return stubPrefix;
	}

	/**
	 * @return serviceClass
	 */
	public Class<?> getServiceClass() {
		return serviceClass;
	}

}
