package net.gdface.codegen.webclient;

import org.apache.commons.cli.Options;

import net.gdface.cli.Context;
import net.gdface.codegen.generator.CodeWriter;
import net.gdface.codegen.generator.CxxCodeWriter;
import net.gdface.codegen.generator.Generator;
import net.gdface.codegen.generator.GeneratorConfiguration;

/**
 * 
 * gsoap stub相关代码生成
 * @author guyadong
 *
 */
public class GSoapStubGenerator extends Generator {
	private final GSoapStubOptions options = GSoapStubOptions.getInstance();
	protected GSoapStubConfiguration config;

	public GSoapStubGenerator() {
		config = new GSoapStubConfiguration();
	}

	public static void main(String[] args) {
		new GSoapStubGenerator().parseCommandLine(args).initEngine().generate();
	}

	@Override
	protected CodeWriter getCodeWriter() {
		return new CxxCodeWriter(config.getOutputLocation());
	}

	@Override
	protected Context createEngineContext() {
		Context context = super.createEngineContext();
		GSoapStub newSourceInfo = new GSoapStub(config.getServiceClass(), config.getStubFolder(), config.getStubPrefix());
		context.setProperty(SOURCE_INFO, newSourceInfo);
		return context;
	}

	@Override
	protected Options getOptions() {
		return options.getOptions();
	}

	@Override
	protected GeneratorConfiguration getGeneratorConfiguration() {
		return config;
	}

}
