package net.gdface.codegen.webclient;

import java.io.File;

import net.gdface.codegen.generator.GeneratorOptions;

import org.apache.commons.cli.Option;
/**
 * 定义{@link GSoapStubGenerator}的命令行参数
 * @author guyadong
 *
 */
public class GSoapStubOptions extends GeneratorOptions implements GSoapConstants,WebClientConstants {
	private final static GSoapStubOptions instance = new GSoapStubOptions();
	
	@Override
	protected void addOptionalOptions() {
		// 删除PACKAGE_OPTION必选项
	}

	protected GSoapStubOptions() {
		options.addOption(Option.builder(GSOAP_STUB_FOLDER_OPTION).longOpt(GSOAP_STUB_FOLDER_OPTION_LONG).desc(GSOAP_STUB_FOLDER_OPTION_DESC)
				.numberOfArgs(1).type(File.class).required().build());
		options.addOption(Option.builder(GSOAP_STUBPREFIX_OPTION).longOpt(GSOAP_STUBPREFIX_OPTION_LONG).desc(GSOAP_STUBPREFIX_OPTION_DESC)
				.numberOfArgs(1).build());	
		options.addOption(Option.builder(WebClientConstants.CLASSNAME_OPTION)
				.longOpt(WebClientConstants.CLASSNAME_OPTION_LONG).desc(CLASSNAME_OPTION_DESC).numberOfArgs(1)
				.type(Class.class).required().build());
	}

	/**
	 * @return instance
	 */
	public static GSoapStubOptions getInstance() {
		return instance;
	}

}
