package net.gdface.codegen.webclient;

import org.apache.commons.cli.Options;

import net.gdface.cli.Context;
import net.gdface.codegen.generator.GeneratorConfiguration;

public class KSoapClientGenerator extends WebClientGenerator {
	private final KSoapClientOptions options = KSoapClientOptions.getInstance();
	protected KSoapClientConfiguration config;

	public KSoapClientGenerator() {
		config = new KSoapClientConfiguration();
	}

	public static void main(String[] args) {
		new KSoapClientGenerator().parseCommandLine(args).initEngine().generate();
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	protected Context createEngineContext() {
		Context context = super.createEngineContext();
		KSoapClient newSourceInfo = new KSoapClient(config.getInterfaceClass(), config.getRefClass(),
				config.getServiceClass(), config.getServiceName(), config.getStubPackage());
		if (!newSourceInfo.compile())
			System.exit(1);
		context.setProperty(SOURCE_INFO, newSourceInfo);
		return context;
	}

	@Override
	protected Options getOptions() {
		return options.getOptions();
	}

	@Override
	protected GeneratorConfiguration getGeneratorConfiguration() {
		return config;
	}

}
