package net.gdface.codegen.webclient;

import java.io.File;

import net.gdface.codegen.generator.GeneratorOptions;

import org.apache.commons.cli.Option;

public class KSoapStubOptions extends GeneratorOptions implements WebClientConstants{
	private final static KSoapStubOptions instance = new KSoapStubOptions();

	/**
	 * 
	 */
	protected KSoapStubOptions() {
		options.addOption(Option.builder(SERVICE_NAME_OPTION).longOpt(SERVICE_NAME_OPTION_LONG).desc("Service name")
				.numberOfArgs(1).build());
		options.addOption(Option.builder(WebClientConstants.CLASSNAME_OPTION)
				.longOpt(WebClientConstants.CLASSNAME_OPTION_LONG).desc(CLASSNAME_OPTION_DESC).numberOfArgs(1)
				.type(Class.class).required().build());
		options.addOption(Option.builder(WSDL_LOCATION_URI_OPTION).desc("WSDL file location").numberOfArgs(1)
				.type(File.class).required().build());
		options.addOption(Option.builder(INDEPENDENT_SEHEMA_OPTION).longOpt(INDEPENDENT_SEHEMA_OPTION_LONG)
				.desc(INDEPENDENT_SEHEMA_OPTION_DESC).argName("schema,...schema").numberOfArgs(1).build());
	}

	/**
	 * @return instance
	 */
	public static KSoapStubOptions getInstance() {
		return instance;
	}

}
