package net.gdface.codegen.webclient;

import net.gdface.codegen.generator.GeneratorConfiguration;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class WebClientConfiguration extends GeneratorConfiguration implements WebClientConstants {

	private Class<?> serviceClass;
	private Class<?> refClass;
	private Class<?> interfaceClass;
	private Class<?> baseClass;
	private String serviceName;

	/**
	 * 
	 */
	protected WebClientConfiguration() {
		defaultValue.setProperty(SERVICE_NAME_OPTION_LONG, "");
	}

	@Override
	public void loadConfig(Options options, CommandLine cmd) throws ParseException {
		super.loadConfig(options, cmd);
		serviceClass = getProperty(WebClientConstants.CLASSNAME_OPTION_LONG);
		serviceName = getProperty(SERVICE_NAME_OPTION_LONG);
		if(serviceName.isEmpty())//如果没有指定，则使用serviceClass类名做服务名
			serviceName=serviceClass.getSimpleName();
		interfaceClass = getProperty(INTERFACE_CLASS_OPTION_LONG);
		refClass = getProperty(REFERENCE_CLASS_OPTION_LONG);
		baseClass = getProperty(BASE_CLASS_OPTION_LONG);
	}

	/**
	 * @return serviceClass
	 */
	public Class<?> getServiceClass() {
		return serviceClass;
	}

	/**
	 * @return serviceName
	 */
	public String getServiceName() {
		return serviceName;
	}

	/**
	 * @return refClass
	 */
	public Class<?> getRefClass() {
		return refClass;
	}

	/**
	 * @return interfaceClass
	 */
	public Class<?> getInterfaceClass() {
		return interfaceClass;
	}

	/**
	 * @return baseClass
	 */
	public Class<?> getBaseClass() {
		return baseClass;
	}

}
