package net.gdface.codegen.webclient;

import net.gdface.codegen.generator.GeneratorOptions;
import org.apache.commons.cli.Option;

public class WebClientOptions extends GeneratorOptions implements WebClientConstants {
	private final static WebClientOptions instance = new WebClientOptions();

	/**
	 * 
	 */
	protected WebClientOptions() {
		options.addOption(Option.builder(SERVICE_NAME_OPTION).longOpt(SERVICE_NAME_OPTION_LONG).desc("Service name")
				.numberOfArgs(1).build());
		options.addOption(Option.builder(WebClientConstants.CLASSNAME_OPTION)
				.longOpt(WebClientConstants.CLASSNAME_OPTION_LONG).desc(CLASSNAME_OPTION_DESC).numberOfArgs(1)
				.type(Class.class).required().build());
		options.addOption(Option.builder(INTERFACE_CLASS_OPTION).longOpt(INTERFACE_CLASS_OPTION_LONG)
				.desc(INTERFACE_CLASS_OPTION_DESC).numberOfArgs(1).type(Class.class).required().build());
		options.addOption(Option.builder(REFERENCE_CLASS_OPTION).longOpt(REFERENCE_CLASS_OPTION_LONG)
				.desc(REFERENCE_CLASS_OPTION_DESC).numberOfArgs(1).type(Class.class).build());
	}

	/**
	 * @return instance
	 */
	public static WebClientOptions getInstance() {
		return instance;
	}

}
