/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.net.UnknownHostException;
import jcifs.CIFSContext;
import jcifs.NameServiceClient;
import jcifs.context.SingletonContext;
import jcifs.netbios.NameServiceClientImpl;

public class JcifsUtil {
    private static final NameServiceClient nsc = new NameServiceClientImpl((CIFSContext)SingletonContext.getInstance());

    public static String hostAddressOf(String host) throws UnknownHostException {
        return nsc.getByName(host).getHostAddress();
    }

    public static String getAddressIfPossible(String host) {
        try {
            return nsc.getByName(host).getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static boolean isResolvableHost(String host) {
        return JcifsUtil.getAddressIfPossible(host) != null;
    }
}

