/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

public class MultiCastDispatcher
implements Runnable {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private final InetAddress group;
    private final int port;
    private final Predicate<byte[]> processor;
    private final Predicate<Throwable> onerr;
    private Boolean stopListener = null;
    private final byte[] message;
    private MulticastSocket multicastSocket;

    public MultiCastDispatcher(InetAddress group, int port, int bufferSize, Predicate<byte[]> processor, Predicate<Throwable> onerr) {
        Preconditions.checkArgument((null != group ? 1 : 0) != 0, (Object)"group is null");
        Preconditions.checkArgument((boolean)group.isMulticastAddress(), (String)"group %s is not a multicast address", (Object)group);
        this.group = group;
        this.port = port;
        this.processor = (Predicate)Preconditions.checkNotNull(processor, (Object)"processor is null");
        this.onerr = (Predicate)MoreObjects.firstNonNull(onerr, (Object)Predicates.alwaysTrue());
        this.message = new byte[bufferSize <= 0 ? 1024 : bufferSize];
    }

    public MultiCastDispatcher(String bindaddr, int port, int bufferSize, Predicate<byte[]> processor, Predicate<Throwable> onerr) throws UnknownHostException {
        this(InetAddress.getByName((String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)bindaddr), (Object)"bindaddr is null or empty")), port, bufferSize, processor, onerr);
    }

    public MultiCastDispatcher(String hostPort, int bufferSize, Predicate<byte[]> processor, Predicate<Throwable> onerr) throws UnknownHostException {
        this(HostAndPort.fromString((String)hostPort).getHost(), HostAndPort.fromString((String)hostPort).getPort(), bufferSize, processor, onerr);
    }

    public MultiCastDispatcher init() throws IOException {
        if (null == this.multicastSocket) {
            this.multicastSocket = new MulticastSocket(this.port);
            this.multicastSocket.joinGroup(this.group);
        }
        return this;
    }

    @Override
    public void run() {
        this.stopListener = Boolean.FALSE;
        DatagramPacket packet = new DatagramPacket(this.message, this.message.length);
        try {
            while (!Boolean.TRUE.equals(this.stopListener)) {
                try {
                    Preconditions.checkArgument((this.multicastSocket != null ? 1 : 0) != 0, (Object)"multicastSocket is uninitizlied");
                    this.multicastSocket.receive(packet);
                    byte[] recevied = new byte[packet.getLength()];
                    System.arraycopy(this.message, 0, recevied, 0, packet.getLength());
                    if (this.processor.apply((Object)recevied)) continue;
                }
                catch (Exception e) {
                    if (this.onerr.apply((Object)e)) continue;
                }
                break;
            }
        }
        finally {
            try {
                this.multicastSocket.leaveGroup(this.group);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.multicastSocket.close();
            this.multicastSocket = null;
            this.stopListener = null;
        }
    }

    public boolean isRunning() {
        return Boolean.FALSE.equals(this.stopListener);
    }

    public MultiCastDispatcher running() {
        this.stopListener = Boolean.FALSE;
        return this;
    }

    public synchronized void stop() {
        this.stopListener = Boolean.TRUE;
    }

    public InetAddress getGroup() {
        return this.group;
    }

    public int getPort() {
        return this.port;
    }
}

