/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;

public class ParameterizedTypeImpl
implements ParameterizedType {
    private Type[] actualTypeArguments;
    private Class<?> rawType;
    private Type ownerType;
    public static final Function<Type, Type> WRAPPER = new Function<Type, Type>(){

        public Type apply(Type input) {
            if (input instanceof ParameterizedTypeImpl) {
                return input;
            }
            if (input instanceof ParameterizedType) {
                return new ParameterizedTypeImpl((ParameterizedType)input);
            }
            return input;
        }
    };

    public ParameterizedTypeImpl(ParameterizedType source) {
        this(TypeToken.of((Type)((Type)Preconditions.checkNotNull((Object)source))).getRawType(), source.getActualTypeArguments(), source.getOwnerType());
    }

    public ParameterizedTypeImpl(Class<?> rawType, Type[] actualTypeArguments, Type ownerType) {
        Preconditions.checkArgument((null != rawType && null != actualTypeArguments ? 1 : 0) != 0);
        this.actualTypeArguments = Lists.transform((List)Lists.newArrayList((Object[])actualTypeArguments), WRAPPER).toArray(new Type[0]);
        this.rawType = rawType;
        this.ownerType = (Type)WRAPPER.apply(ownerType != null ? ownerType : rawType.getDeclaringClass());
        this.validateConstructorArguments();
    }

    private void validateConstructorArguments() {
        TypeVariable<Class<?>>[] formals = this.rawType.getTypeParameters();
        if (formals.length != this.actualTypeArguments.length) {
            throw new MalformedParameterizedTypeException();
        }
        for (int i = 0; i < this.actualTypeArguments.length; ++i) {
        }
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.actualTypeArguments.clone();
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public boolean equals(Object o) {
        if (o instanceof ParameterizedType) {
            ParameterizedType that = (ParameterizedType)o;
            if (this == that) {
                return true;
            }
            Type thatOwner = that.getOwnerType();
            Type thatRawType = that.getRawType();
            return (this.ownerType == null ? thatOwner == null : this.ownerType.equals(thatOwner)) && (this.rawType == null ? thatRawType == null : this.rawType.equals(thatRawType)) && Arrays.equals(this.actualTypeArguments, that.getActualTypeArguments());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.actualTypeArguments) ^ (this.ownerType == null ? 0 : this.ownerType.hashCode()) ^ (this.rawType == null ? 0 : this.rawType.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.ownerType != null) {
            if (this.ownerType instanceof Class) {
                sb.append(((Class)this.ownerType).getName());
            } else {
                sb.append(this.ownerType.toString());
            }
            sb.append(".");
            if (this.ownerType instanceof ParameterizedTypeImpl) {
                sb.append(this.rawType.getName().replace(((ParameterizedTypeImpl)this.ownerType).rawType.getName() + "$", ""));
            } else {
                sb.append(this.rawType.getSimpleName());
            }
        } else {
            sb.append(this.rawType.getName());
        }
        if (this.actualTypeArguments != null && this.actualTypeArguments.length > 0) {
            sb.append("<");
            boolean first = true;
            for (Type t : this.actualTypeArguments) {
                if (!first) {
                    sb.append(", ");
                }
                if (t instanceof Class) {
                    sb.append(((Class)t).getName());
                } else {
                    sb.append(t.toString());
                }
                first = false;
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public ParameterizedType transform(Type oldType, Type newType) {
        Preconditions.checkNotNull((Object)oldType);
        Preconditions.checkNotNull((Object)newType);
        Type[] typeArgs = this.getActualTypeArguments();
        for (int i = 0; i < typeArgs.length; ++i) {
            if (typeArgs[i] != oldType) continue;
            typeArgs[i] = newType;
        }
        return new ParameterizedTypeImpl(TypeToken.of((Type)this).getRawType(), typeArgs, this.getOwnerType());
    }

    public ParameterizedType transform(Type[] newTypeArguments) {
        Preconditions.checkNotNull((Object)newTypeArguments);
        Type[] typeArgs = this.getActualTypeArguments();
        Preconditions.checkArgument((newTypeArguments.length == typeArgs.length ? 1 : 0) != 0);
        for (int i = 0; i < typeArgs.length; ++i) {
            if (null == newTypeArguments[i]) continue;
            typeArgs[i] = newTypeArguments[i];
        }
        return new ParameterizedTypeImpl(TypeToken.of((Type)this).getRawType(), typeArgs, this.getOwnerType());
    }
}

