/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftField;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.thoughtworks.paranamer.AdaptiveParanamer;
import com.thoughtworks.paranamer.AnnotationParanamer;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

public final class ReflectionHelper {
    private static final Type MAP_KEY_TYPE;
    private static final Type MAP_VALUE_TYPE;
    private static final Type ITERATOR_TYPE;
    private static final Type ITERATOR_ELEMENT_TYPE;
    private static final Type FUTURE_RETURN_TYPE;
    private static final Paranamer PARANAMER;

    private ReflectionHelper() {
    }

    public static boolean isArray(Type type) {
        return TypeToken.of((Type)type).getComponentType() != null;
    }

    public static Class<?> getArrayOfType(Type componentType) {
        Class rawComponentType = TypeToken.of((Type)componentType).getRawType();
        return Array.newInstance(rawComponentType, 0).getClass();
    }

    public static Type getMapKeyType(Type type) {
        return TypeToken.of((Type)type).resolveType(MAP_KEY_TYPE).getType();
    }

    public static Type getMapValueType(Type type) {
        return TypeToken.of((Type)type).resolveType(MAP_VALUE_TYPE).getType();
    }

    public static Type getIterableType(Type type) {
        return TypeToken.of((Type)type).resolveType(ITERATOR_TYPE).resolveType(ITERATOR_ELEMENT_TYPE).getType();
    }

    public static Type getFutureReturnType(Type type) {
        return TypeToken.of((Type)type).resolveType(FUTURE_RETURN_TYPE).getType();
    }

    public static <T extends Annotation> Set<T> getEffectiveClassAnnotations(Class<?> type, Class<T> annotation) {
        if (type.isAnnotationPresent(annotation)) {
            return ImmutableSet.of(type.getAnnotation(annotation));
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ReflectionHelper.addEffectiveClassAnnotations(type, annotation, builder);
        return builder.build();
    }

    private static <T extends Annotation> void addEffectiveClassAnnotations(Class<?> type, Class<T> annotation, ImmutableSet.Builder<T> builder) {
        if (type.isAnnotationPresent(annotation)) {
            builder.add(type.getAnnotation(annotation));
            return;
        }
        if (type.getSuperclass() != null) {
            ReflectionHelper.addEffectiveClassAnnotations(type.getSuperclass(), annotation, builder);
        }
        for (Class<?> anInterface : type.getInterfaces()) {
            ReflectionHelper.addEffectiveClassAnnotations(anInterface, annotation, builder);
        }
    }

    public static Iterable<Method> getAllDeclaredMethods(Class<?> type) {
        ImmutableList.Builder methods = ImmutableList.builder();
        for (Class<?> clazz = type; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            methods.addAll((Iterable)ImmutableList.copyOf((Object[])clazz.getDeclaredMethods()));
        }
        return methods.build();
    }

    public static Iterable<Field> getAllDeclaredFields(Class<?> type) {
        ImmutableList.Builder fields = ImmutableList.builder();
        for (Class<?> clazz = type; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            fields.addAll((Iterable)ImmutableList.copyOf((Object[])clazz.getDeclaredFields()));
        }
        return fields.build();
    }

    public static Collection<Method> findAnnotatedMethods(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : type.getMethods()) {
            Method managedMethod;
            if (method.isSynthetic() || method.isBridge() || Modifier.isStatic(method.getModifiers()) || (managedMethod = ReflectionHelper.findAnnotatedMethod(type, annotation, method.getName(), method.getParameterTypes())) == null) continue;
            result.add(managedMethod);
        }
        return result;
    }

    public static Method findAnnotatedMethod(Class<?> configClass, Class<? extends Annotation> annotation, String methodName, Class<?> ... paramTypes) {
        Method managedMethod;
        try {
            Method method = configClass.getDeclaredMethod(methodName, paramTypes);
            if (method != null && method.isAnnotationPresent(annotation)) {
                return method;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (configClass.getSuperclass() != null && (managedMethod = ReflectionHelper.findAnnotatedMethod(configClass.getSuperclass(), annotation, methodName, paramTypes)) != null) {
            return managedMethod;
        }
        for (Class<?> iface : configClass.getInterfaces()) {
            Method managedMethod2 = ReflectionHelper.findAnnotatedMethod(iface, annotation, methodName, paramTypes);
            if (managedMethod2 == null) continue;
            return managedMethod2;
        }
        return null;
    }

    public static Collection<Field> findAnnotatedFields(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : type.getFields()) {
            if (field.isSynthetic() || Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(annotation)) continue;
            result.add(field);
        }
        return result;
    }

    public static String[] extractParameterNames(AccessibleObject methodOrConstructor) {
        String[] names = PARANAMER.lookupParameterNames(methodOrConstructor);
        return names;
    }

    public static String extractFieldName(Method method) {
        Preconditions.checkNotNull((Object)method, (Object)"method is null");
        return ReflectionHelper.extractFieldName(method.getName());
    }

    public static String extractFieldName(String methodName) {
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName is null");
        if ((methodName.startsWith("get") || methodName.startsWith("set")) && methodName.length() > 3) {
            String name = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            return name;
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            String name = Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
            return name;
        }
        return methodName;
    }

    public static Type resolveFieldType(Type structType, Type genericType) {
        return TypeToken.of((Type)structType).resolveType(genericType).getType();
    }

    public static Type[] resolveFieldTypes(final Type structType, Type[] genericTypes) {
        return Lists.transform(Arrays.asList(genericTypes), (Function)new Function<Type, Type>(){

            @Nullable
            public Type apply(@Nullable Type input) {
                return ReflectionHelper.resolveFieldType(structType, input);
            }
        }).toArray(new Type[0]);
    }

    static {
        try {
            Method mapPutMethod = Map.class.getMethod("put", Object.class, Object.class);
            MAP_KEY_TYPE = mapPutMethod.getGenericParameterTypes()[0];
            MAP_VALUE_TYPE = mapPutMethod.getGenericParameterTypes()[1];
            ITERATOR_TYPE = Iterable.class.getMethod("iterator", new Class[0]).getGenericReturnType();
            ITERATOR_ELEMENT_TYPE = Iterator.class.getMethod("next", new Class[0]).getGenericReturnType();
            Method futureGetMethod = Future.class.getMethod("get", new Class[0]);
            FUTURE_RETURN_TYPE = futureGetMethod.getGenericReturnType();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        PARANAMER = new CachingParanamer((Paranamer)new AdaptiveParanamer(new Paranamer[]{new ThriftFieldParanamer(), new BytecodeReadingParanamer(), new GeneralParanamer()}));
    }

    private static class GeneralParanamer
    implements Paranamer {
        private GeneralParanamer() {
        }

        public String[] lookupParameterNames(AccessibleObject methodOrConstructor) {
            String[] names;
            if (methodOrConstructor instanceof Method) {
                Method method = (Method)methodOrConstructor;
                names = new String[method.getParameterTypes().length];
            } else if (methodOrConstructor instanceof Constructor) {
                Constructor constructor = (Constructor)methodOrConstructor;
                names = new String[constructor.getParameterTypes().length];
            } else {
                throw new IllegalArgumentException("methodOrConstructor is not an instance of Method or Constructor but is " + methodOrConstructor.getClass().getName());
            }
            for (int i = 0; i < names.length; ++i) {
                names[i] = "arg" + i;
            }
            return names;
        }

        public String[] lookupParameterNames(AccessibleObject methodOrConstructor, boolean throwExceptionIfMissing) {
            return this.lookupParameterNames(methodOrConstructor);
        }
    }

    private static class ThriftFieldParanamer
    extends AnnotationParanamer {
        private ThriftFieldParanamer() {
        }

        protected String getNamedValue(Annotation annotation) {
            String name;
            if (annotation instanceof ThriftField && !(name = ((ThriftField)annotation).name()).isEmpty()) {
                return name;
            }
            return super.getNamedValue(annotation);
        }

        protected boolean isNamed(Annotation annotation) {
            return annotation instanceof ThriftField || super.isNamed(annotation);
        }
    }
}

