/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import com.facebook.swift.codec.metadata.AbstractThriftMetadataBuilder;
import com.facebook.swift.codec.metadata.ConstructorInjection;
import com.facebook.swift.codec.metadata.FieldExtractor;
import com.facebook.swift.codec.metadata.FieldInjection;
import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.FieldMetadata;
import com.facebook.swift.codec.metadata.MethodExtractor;
import com.facebook.swift.codec.metadata.ParameterInjection;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftConstructorInjection;
import com.facebook.swift.codec.metadata.ThriftExtraction;
import com.facebook.swift.codec.metadata.ThriftFieldExtractor;
import com.facebook.swift.codec.metadata.ThriftFieldInjection;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftInjection;
import com.facebook.swift.codec.metadata.ThriftMethodExtractor;
import com.facebook.swift.codec.metadata.ThriftMethodInjection;
import com.facebook.swift.codec.metadata.ThriftParameterInjection;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.codec.metadata.TypeCoercion;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ThriftStructMetadataBuilder
extends AbstractThriftMetadataBuilder {
    public ThriftStructMetadataBuilder(ThriftCatalog catalog, Type structType) {
        super(catalog, structType);
        this.verifyClass(ThriftStruct.class);
        this.normalizeThriftFields(catalog);
    }

    @Override
    protected String extractName() {
        ThriftStruct annotation = this.getStructClass().getAnnotation(ThriftStruct.class);
        if (annotation == null) {
            return this.getStructClass().getSimpleName();
        }
        if (!annotation.value().isEmpty()) {
            return annotation.value();
        }
        return this.getStructClass().getSimpleName();
    }

    @Override
    protected Class<?> extractBuilderClass() {
        ThriftStruct annotation = this.getStructClass().getAnnotation(ThriftStruct.class);
        if (annotation != null && !annotation.builder().equals(Void.TYPE)) {
            return annotation.builder();
        }
        return null;
    }

    @Override
    protected void validateConstructors() {
        if (this.constructorInjections.size() > 1) {
            this.metadataErrors.addError("Multiple constructors are annotated with @ThriftConstructor ", this.constructorInjections);
        }
    }

    @Override
    protected boolean isValidateSetter(Method method) {
        return method.getParameterTypes().length >= 1;
    }

    @Override
    public ThriftStructMetadata build() {
        this.metadataErrors.throwIfHasErrors();
        ThriftMethodInjection builderMethodInjection = this.buildBuilderConstructorInjections();
        ThriftConstructorInjection constructorInjections = this.buildConstructorInjection();
        Iterable<ThriftFieldMetadata> fieldsMetadata = this.buildFieldInjections();
        List<ThriftMethodInjection> methodInjections = this.buildMethodInjections();
        return new ThriftStructMetadata(this.structName, this.structType, this.builderType, ThriftStructMetadata.MetadataType.STRUCT, (Optional<ThriftMethodInjection>)Optional.fromNullable((Object)builderMethodInjection), (List<String>)ImmutableList.copyOf((Collection)this.documentation), (List<ThriftFieldMetadata>)ImmutableList.copyOf(fieldsMetadata), (Optional<ThriftConstructorInjection>)Optional.of((Object)constructorInjections), methodInjections);
    }

    private ThriftConstructorInjection buildConstructorInjection() {
        return (ThriftConstructorInjection)Iterables.getOnlyElement((Iterable)Lists.transform((List)this.constructorInjections, (Function)new Function<ConstructorInjection, ThriftConstructorInjection>(){

            public ThriftConstructorInjection apply(ConstructorInjection injection) {
                return new ThriftConstructorInjection(injection.getConstructor(), ThriftStructMetadataBuilder.this.buildParameterInjections(injection.getParameters()));
            }
        }));
    }

    @Override
    protected ThriftFieldMetadata buildField(Collection<FieldMetadata> input) {
        short id = -1;
        String name = null;
        ThriftField.Requiredness requiredness = ThriftField.Requiredness.UNSPECIFIED;
        ThriftType type = null;
        ImmutableList.Builder injections = ImmutableList.builder();
        ThriftExtraction extraction = null;
        for (FieldMetadata fieldMetadata : input) {
            id = fieldMetadata.getId();
            name = fieldMetadata.getName();
            requiredness = fieldMetadata.getRequiredness();
            type = this.catalog.getThriftType(fieldMetadata.getJavaType());
            if (fieldMetadata instanceof FieldInjection) {
                FieldInjection fieldInjection = (FieldInjection)fieldMetadata;
                injections.add((Object)new ThriftFieldInjection(fieldInjection.getId(), fieldInjection.getName(), fieldInjection.getField(), fieldInjection.getType()));
                continue;
            }
            if (fieldMetadata instanceof ParameterInjection) {
                ParameterInjection parameterInjection = (ParameterInjection)fieldMetadata;
                injections.add((Object)new ThriftParameterInjection(parameterInjection.getId(), parameterInjection.getName(), parameterInjection.getParameterIndex(), fieldMetadata.getJavaType()));
                continue;
            }
            if (fieldMetadata instanceof FieldExtractor) {
                FieldExtractor fieldExtractor = (FieldExtractor)fieldMetadata;
                extraction = new ThriftFieldExtractor(fieldExtractor.getId(), fieldExtractor.getName(), fieldExtractor.getType(), fieldExtractor.getField(), fieldExtractor.getJavaType());
                continue;
            }
            if (!(fieldMetadata instanceof MethodExtractor)) continue;
            MethodExtractor methodExtractor = (MethodExtractor)fieldMetadata;
            extraction = new ThriftMethodExtractor(methodExtractor.getId(), methodExtractor.getName(), methodExtractor.getType(), methodExtractor.getMethod(), methodExtractor.getJavaType());
        }
        TypeCoercion coercion = null;
        if (type.isCoerced()) {
            coercion = this.catalog.getDefaultCoercion(type.getJavaType());
        }
        ThriftFieldMetadata thriftFieldMetadata = new ThriftFieldMetadata(id, requiredness, type, name, FieldKind.THRIFT_FIELD, (List<ThriftInjection>)injections.build(), (Optional<ThriftConstructorInjection>)Optional.absent(), (Optional<ThriftMethodInjection>)Optional.absent(), (Optional<ThriftExtraction>)Optional.fromNullable(extraction), (Optional<TypeCoercion>)Optional.fromNullable((Object)coercion));
        return thriftFieldMetadata;
    }
}

