/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftConstructor;
import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.metadata.ConstructorInjection;
import com.facebook.swift.codec.metadata.Extractor;
import com.facebook.swift.codec.metadata.FieldExtractor;
import com.facebook.swift.codec.metadata.FieldInjection;
import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.FieldMetadata;
import com.facebook.swift.codec.metadata.MetadataErrors;
import com.facebook.swift.codec.metadata.MethodExtractor;
import com.facebook.swift.codec.metadata.MethodInjection;
import com.facebook.swift.codec.metadata.ParameterInjection;
import com.facebook.swift.codec.metadata.ReflectionHelper;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftMethodInjection;
import com.facebook.swift.codec.metadata.ThriftParameterInjection;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftType;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.inject.internal.MoreTypes;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractThriftMetadataBuilder {
    protected final String structName;
    protected final Type structType;
    protected final Type builderType;
    protected final List<String> documentation;
    protected final List<FieldMetadata> fields = Lists.newArrayList();
    protected final List<Extractor> extractors = Lists.newArrayList();
    protected final List<MethodInjection> builderMethodInjections = Lists.newArrayList();
    protected final List<ConstructorInjection> constructorInjections = Lists.newArrayList();
    protected final List<FieldInjection> fieldInjections = Lists.newArrayList();
    protected final List<MethodInjection> methodInjections = Lists.newArrayList();
    protected final ThriftCatalog catalog;
    protected final MetadataErrors metadataErrors;

    protected AbstractThriftMetadataBuilder(ThriftCatalog catalog, Type structType) {
        this.catalog = (ThriftCatalog)Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null");
        this.structType = (Type)Preconditions.checkNotNull((Object)structType, (Object)"structType is null");
        this.metadataErrors = new MetadataErrors(catalog.getMonitor());
        this.structName = this.extractName();
        this.builderType = this.extractBuilderType();
        this.documentation = ThriftCatalog.getThriftDocumentation(this.getStructClass());
        this.extractFromConstructors();
        this.extractFromFields();
        this.extractFromMethods();
    }

    protected abstract String extractName();

    protected abstract Class<?> extractBuilderClass();

    protected abstract void validateConstructors();

    protected abstract boolean isValidateSetter(Method var1);

    protected abstract ThriftFieldMetadata buildField(Collection<FieldMetadata> var1);

    public abstract ThriftStructMetadata build();

    public MetadataErrors getMetadataErrors() {
        return this.metadataErrors;
    }

    public Class<?> getStructClass() {
        return TypeToken.of((Type)this.structType).getRawType();
    }

    public Class<?> getBuilderClass() {
        return TypeToken.of((Type)this.builderType).getRawType();
    }

    private Type extractBuilderType() {
        Class<?> builderClass = this.extractBuilderClass();
        if (builderClass == null) {
            return null;
        }
        if (builderClass.getTypeParameters().length == 0) {
            return builderClass;
        }
        if (!(this.structType instanceof ParameterizedType)) {
            this.metadataErrors.addError("Builder class '%s' may only be generic if the type it builds ('%s') is also generic", builderClass.getName(), this.getStructClass().getName());
            return builderClass;
        }
        if (builderClass.getTypeParameters().length != this.getStructClass().getTypeParameters().length) {
            this.metadataErrors.addError("Generic builder class '%s' must have the same number of type parameters as the type it builds ('%s')", builderClass.getName(), this.getStructClass().getName());
            return builderClass;
        }
        ParameterizedType parameterizedStructType = (ParameterizedType)this.structType;
        return new MoreTypes.ParameterizedTypeImpl(builderClass.getEnclosingClass(), builderClass, parameterizedStructType.getActualTypeArguments());
    }

    protected final void verifyClass(Class<? extends Annotation> annotation) {
        String annotationName = annotation.getSimpleName();
        String structClassName = this.getStructClass().getName();
        if (!Modifier.isPublic(this.getStructClass().getModifiers())) {
            this.metadataErrors.addError("%s class '%s' is not public", annotationName, structClassName);
        }
        if (!Modifier.isFinal(this.getStructClass().getModifiers())) {
            this.metadataErrors.addError("%s class '%s' is not final (thrift does not support polymorphic data types)", annotationName, structClassName);
        }
        if (!this.getStructClass().isAnnotationPresent(annotation)) {
            this.metadataErrors.addError("%s class '%s' does not have a @%s annotation", annotationName, structClassName, annotationName);
        }
    }

    protected final void extractFromConstructors() {
        if (this.builderType == null) {
            this.addConstructors(this.structType);
        } else {
            this.addConstructors(this.builderType);
            this.addBuilderMethods();
            for (Constructor<?> constructor : this.getStructClass().getConstructors()) {
                if (!constructor.isAnnotationPresent(ThriftConstructor.class)) continue;
                this.metadataErrors.addWarning("Thrift class '%s' has a builder class, but constructor '%s' annotated with @ThriftConstructor", this.getStructClass().getName(), constructor);
            }
        }
    }

    protected final void addConstructors(Type type) {
        Class clazz = TypeToken.of((Type)type).getRawType();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.isSynthetic() || !constructor.isAnnotationPresent(ThriftConstructor.class)) continue;
            if (!Modifier.isPublic(constructor.getModifiers())) {
                this.metadataErrors.addError("@ThriftConstructor '%s' is not public", constructor.toGenericString());
                continue;
            }
            List<ParameterInjection> parameters = this.getParameterInjections(type, constructor.getParameterAnnotations(), ReflectionHelper.resolveFieldTypes(this.structType, constructor.getGenericParameterTypes()), ReflectionHelper.extractParameterNames(constructor));
            if (parameters == null) continue;
            this.fields.addAll(parameters);
            this.constructorInjections.add(new ConstructorInjection(constructor, parameters));
        }
        if (this.constructorInjections.isEmpty()) {
            try {
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    this.metadataErrors.addError("Default constructor '%s' is not public", constructor.toGenericString());
                }
                this.constructorInjections.add(new ConstructorInjection(constructor, new ParameterInjection[0]));
            }
            catch (NoSuchMethodException e) {
                this.metadataErrors.addError("Struct class '%s' does not have a public no-arg constructor", clazz.getName());
            }
        }
        this.validateConstructors();
    }

    protected final void addBuilderMethods() {
        for (Method method : ReflectionHelper.findAnnotatedMethods(this.getBuilderClass(), ThriftConstructor.class)) {
            List<ParameterInjection> parameters = this.getParameterInjections(this.builderType, method.getParameterAnnotations(), ReflectionHelper.resolveFieldTypes(this.builderType, method.getGenericParameterTypes()), ReflectionHelper.extractParameterNames(method));
            if (parameters != null) {
                this.fields.addAll(parameters);
                this.builderMethodInjections.add(new MethodInjection(method, parameters));
            }
            if (this.getStructClass().isAssignableFrom(method.getReturnType())) continue;
            this.metadataErrors.addError("'%s' says that '%s' is its builder class, but @ThriftConstructor method '%s' in the builder does not build an instance assignable to that type", this.structType, this.builderType, method.getName());
        }
        for (Method method : ReflectionHelper.getAllDeclaredMethods(this.getBuilderClass())) {
            if (!method.isAnnotationPresent(ThriftConstructor.class) && !this.hasThriftFieldAnnotation(method)) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                this.metadataErrors.addError("@ThriftConstructor method '%s' is not public", method.toGenericString());
            }
            if (!Modifier.isStatic(method.getModifiers())) continue;
            this.metadataErrors.addError("@ThriftConstructor method '%s' is static", method.toGenericString());
        }
        if (this.builderMethodInjections.isEmpty()) {
            this.metadataErrors.addError("Struct builder class '%s' does not have a public builder method annotated with @ThriftConstructor", this.getBuilderClass().getName());
        }
        if (this.builderMethodInjections.size() > 1) {
            this.metadataErrors.addError("Multiple builder methods are annotated with @ThriftConstructor ", this.builderMethodInjections);
        }
    }

    protected final void extractFromFields() {
        if (this.builderType == null) {
            this.addFields(this.getStructClass(), true, true);
        } else {
            this.addFields(this.getBuilderClass(), false, true);
            this.addFields(this.getStructClass(), true, false);
        }
    }

    protected final void addFields(Class<?> clazz, boolean allowReaders, boolean allowWriters) {
        for (Field fieldField : ReflectionHelper.findAnnotatedFields(clazz, ThriftField.class)) {
            this.addField(fieldField, allowReaders, allowWriters);
        }
        for (Field field : ReflectionHelper.getAllDeclaredFields(clazz)) {
            if (!field.isAnnotationPresent(ThriftField.class)) continue;
            if (!Modifier.isPublic(field.getModifiers())) {
                this.metadataErrors.addError("@ThriftField field '%s' is not public", field.toGenericString());
            }
            if (!Modifier.isStatic(field.getModifiers())) continue;
            this.metadataErrors.addError("@ThriftField field '%s' is static", field.toGenericString());
        }
    }

    protected final void addField(Field fieldField, boolean allowReaders, boolean allowWriters) {
        Preconditions.checkArgument((boolean)fieldField.isAnnotationPresent(ThriftField.class));
        ThriftField annotation = fieldField.getAnnotation(ThriftField.class);
        if (allowReaders) {
            FieldExtractor fieldExtractor = new FieldExtractor(this.structType, fieldField, annotation, FieldKind.THRIFT_FIELD);
            this.fields.add(fieldExtractor);
            this.extractors.add(fieldExtractor);
        }
        if (allowWriters) {
            FieldInjection fieldInjection = new FieldInjection(this.structType, fieldField, annotation, FieldKind.THRIFT_FIELD);
            this.fields.add(fieldInjection);
            this.fieldInjections.add(fieldInjection);
        }
    }

    protected final void extractFromMethods() {
        if (this.builderType != null) {
            this.addMethods(this.builderType, false, true);
            this.addMethods(this.structType, true, false);
        } else {
            this.addMethods(this.structType, true, true);
        }
    }

    protected final void addMethods(Type type, boolean allowReaders, boolean allowWriters) {
        Class clazz = TypeToken.of((Type)type).getRawType();
        for (Method fieldMethod : ReflectionHelper.findAnnotatedMethods(clazz, ThriftField.class)) {
            this.addMethod(type, fieldMethod, allowReaders, allowWriters);
        }
        for (Method method : ReflectionHelper.getAllDeclaredMethods(clazz)) {
            if (!method.isAnnotationPresent(ThriftField.class) && !this.hasThriftFieldAnnotation(method)) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                this.metadataErrors.addError("@ThriftField method '%s' is not public", method.toGenericString());
            }
            if (!Modifier.isStatic(method.getModifiers())) continue;
            this.metadataErrors.addError("@ThriftField method '%s' is static", method.toGenericString());
        }
    }

    protected final void addMethod(Type type, Method method, boolean allowReaders, boolean allowWriters) {
        Preconditions.checkArgument((boolean)method.isAnnotationPresent(ThriftField.class));
        ThriftField annotation = method.getAnnotation(ThriftField.class);
        Class clazz = TypeToken.of((Type)type).getRawType();
        if (this.isValidateGetter(method)) {
            if (allowReaders) {
                MethodExtractor methodExtractor = new MethodExtractor(type, method, annotation, FieldKind.THRIFT_FIELD);
                this.fields.add(methodExtractor);
                this.extractors.add(methodExtractor);
            } else {
                this.metadataErrors.addError("Reader method %s.%s is not allowed on a builder class", clazz.getName(), method.getName());
            }
        } else if (this.isValidateSetter(method)) {
            if (allowWriters) {
                ImmutableList parameters;
                if (method.getParameterTypes().length > 1 || Iterables.any(Arrays.asList(method.getParameterAnnotations()[0]), (Predicate)Predicates.instanceOf(ThriftField.class))) {
                    parameters = this.getParameterInjections(type, method.getParameterAnnotations(), ReflectionHelper.resolveFieldTypes(type, method.getGenericParameterTypes()), ReflectionHelper.extractParameterNames(method));
                    if (annotation.value() != Short.MIN_VALUE) {
                        this.metadataErrors.addError("A method with annotated parameters can not have a field id specified: %s.%s ", clazz.getName(), method.getName());
                    }
                    if (!annotation.name().isEmpty()) {
                        this.metadataErrors.addError("A method with annotated parameters can not have a field name specified: %s.%s ", clazz.getName(), method.getName());
                    }
                    if (annotation.requiredness() == ThriftField.Requiredness.REQUIRED) {
                        this.metadataErrors.addError("A method with annotated parameters can not be marked as required: %s.%s ", clazz.getName(), method.getName());
                    }
                } else {
                    Type parameterType = ReflectionHelper.resolveFieldTypes(type, method.getGenericParameterTypes())[0];
                    parameters = ImmutableList.of((Object)new ParameterInjection(type, 0, annotation, ReflectionHelper.extractFieldName(method), parameterType));
                }
                this.fields.addAll((Collection<FieldMetadata>)parameters);
                this.methodInjections.add(new MethodInjection(method, (List<ParameterInjection>)parameters));
            } else {
                this.metadataErrors.addError("Inject method %s.%s is not allowed on struct class, since struct has a builder", clazz.getName(), method.getName());
            }
        } else {
            this.metadataErrors.addError("Method %s.%s is not a supported getter or setter", clazz.getName(), method.getName());
        }
    }

    protected final boolean hasThriftFieldAnnotation(Method method) {
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation parameterAnnotation : parameterAnnotations = annotationArray[i]) {
                if (!(parameterAnnotation instanceof ThriftField)) continue;
                return true;
            }
        }
        return false;
    }

    protected final boolean isValidateGetter(Method method) {
        return method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    protected final List<ParameterInjection> getParameterInjections(Type type, Annotation[][] parameterAnnotations, Type[] parameterTypes, String[] parameterNames) {
        ArrayList parameters = Lists.newArrayListWithCapacity((int)parameterAnnotations.length);
        for (int parameterIndex = 0; parameterIndex < parameterAnnotations.length; ++parameterIndex) {
            Annotation[] annotations = parameterAnnotations[parameterIndex];
            Type parameterType = parameterTypes[parameterIndex];
            ThriftField thriftField = null;
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof ThriftField)) continue;
                thriftField = (ThriftField)annotation;
            }
            ParameterInjection parameterInjection = new ParameterInjection(type, parameterIndex, thriftField, parameterNames[parameterIndex], parameterType);
            parameters.add(parameterInjection);
        }
        return parameters;
    }

    protected final void normalizeThriftFields(ThriftCatalog catalog) {
        Set<String> fieldsWithConflictingIds = this.inferThriftFieldIds();
        ImmutableListMultimap fieldsById = Multimaps.index(this.fields, FieldMetadata.getThriftFieldId());
        for (Map.Entry entry : fieldsById.asMap().entrySet()) {
            String fieldName2;
            Collection fields = (Collection)entry.getValue();
            if (!((Optional)entry.getKey()).isPresent()) {
                for (String fieldName2 : Sets.newTreeSet((Iterable)Iterables.transform((Iterable)fields, FieldMetadata.getOrExtractThriftFieldName()))) {
                    if (fieldsWithConflictingIds.contains(fieldName2)) continue;
                    this.metadataErrors.addError("Thrift class '%s' fields %s do not have an id", this.structName, Sets.newTreeSet((Iterable)Iterables.transform((Iterable)fields, FieldMetadata.getOrExtractThriftFieldName())));
                }
                continue;
            }
            short fieldId = (Short)((Optional)entry.getKey()).get();
            fieldName2 = this.extractFieldName(fieldId, fields);
            for (FieldMetadata field : fields) {
                field.setName(fieldName2);
            }
            ThriftField.Requiredness requiredness = this.extractFieldRequiredness(fieldId, fieldName2, fields);
            for (FieldMetadata field : fields) {
                field.setRequiredness(requiredness);
            }
            this.verifyFieldType(fieldId, fieldName2, fields, catalog);
        }
    }

    protected final Set<String> inferThriftFieldIds() {
        HashSet<String> fieldsWithConflictingIds = new HashSet<String>();
        ImmutableListMultimap fieldsByExplicitOrExtractedName = Multimaps.index(this.fields, FieldMetadata.getOrExtractThriftFieldName());
        this.inferThriftFieldIds((Multimap<String, FieldMetadata>)fieldsByExplicitOrExtractedName, fieldsWithConflictingIds);
        ImmutableListMultimap fieldsByExtractedName = Multimaps.index(this.fields, FieldMetadata.extractThriftFieldName());
        this.inferThriftFieldIds((Multimap<String, FieldMetadata>)fieldsByExtractedName, fieldsWithConflictingIds);
        return fieldsWithConflictingIds;
    }

    protected final void inferThriftFieldIds(Multimap<String, FieldMetadata> fieldsByName, Set<String> fieldsWithConflictingIds) {
        for (Map.Entry entry : fieldsByName.asMap().entrySet()) {
            Collection fields = (Collection)entry.getValue();
            if (fields.size() <= 1) continue;
            ImmutableSet ids = ImmutableSet.copyOf((Iterable)Optional.presentInstances((Iterable)Iterables.transform((Iterable)fields, FieldMetadata.getThriftFieldId())));
            if (ids.size() > 1) {
                String fieldName = (String)entry.getKey();
                if (fieldsWithConflictingIds.contains(fieldName)) continue;
                this.metadataErrors.addError("Thrift class '%s' field '%s' has multiple ids: %s", this.structName, fieldName, ids.toString());
                fieldsWithConflictingIds.add(fieldName);
                continue;
            }
            if (ids.size() != 1) continue;
            short id = (Short)Iterables.getOnlyElement((Iterable)ids);
            for (FieldMetadata field : fields) {
                field.setId(id);
            }
        }
    }

    protected final String extractFieldName(short id, Collection<FieldMetadata> fields) {
        String name;
        ImmutableSet names = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(fields, FieldMetadata.getThriftFieldName()), (Predicate)Predicates.notNull()));
        if (!names.isEmpty()) {
            if (names.size() > 1) {
                this.metadataErrors.addWarning("Thrift class %s field %s has multiple names %s", this.structName, id, names);
            }
            name = (String)names.iterator().next();
        } else {
            name = (String)Iterables.find((Iterable)Iterables.transform(fields, FieldMetadata.extractThriftFieldName()), (Predicate)Predicates.notNull());
        }
        return name;
    }

    protected final ThriftField.Requiredness extractFieldRequiredness(short fieldId, String fieldName, Collection<FieldMetadata> fields) {
        Predicate<ThriftField.Requiredness> specificRequiredness = new Predicate<ThriftField.Requiredness>(){

            public boolean apply(@Nullable ThriftField.Requiredness input) {
                return input != null && input != ThriftField.Requiredness.UNSPECIFIED;
            }
        };
        ImmutableSet requirednessValues = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(fields, FieldMetadata.getThriftFieldRequiredness()), (Predicate)specificRequiredness));
        if (requirednessValues.size() > 1) {
            this.metadataErrors.addError("Thrift class '%s' field '%s(%d)' has multiple requiredness values: %s", this.structName, fieldName, fieldId, requirednessValues.toString());
        }
        ThriftField.Requiredness resolvedRequiredness = requirednessValues.isEmpty() ? ThriftField.Requiredness.NONE : (ThriftField.Requiredness)requirednessValues.iterator().next();
        return resolvedRequiredness;
    }

    protected final void verifyFieldType(short id, String name, Collection<FieldMetadata> fields, ThriftCatalog catalog) {
        boolean isSupportedType = true;
        for (FieldMetadata field : fields) {
            if (catalog.isSupportedStructFieldType(field.getJavaType())) continue;
            this.metadataErrors.addError("Thrift class '%s' field '%s(%s)' type '%s' is not a supported Java type", this.structName, name, id, TypeToken.of((Type)field.getJavaType()));
            isSupportedType = false;
            break;
        }
        if (isSupportedType) {
            HashSet<ThriftType> types = new HashSet<ThriftType>();
            for (FieldMetadata field : fields) {
                types.add(catalog.getThriftType(field.getJavaType()));
            }
            if (types.size() > 1) {
                this.metadataErrors.addError("Thrift class '%s' field '%s(%s)' has multiple types: %s", this.structName, name, id, types);
            }
        }
    }

    protected final ThriftMethodInjection buildBuilderConstructorInjections() {
        ThriftMethodInjection builderMethodInjection = null;
        if (this.builderType != null) {
            MethodInjection builderMethod = this.builderMethodInjections.get(0);
            builderMethodInjection = new ThriftMethodInjection(builderMethod.getMethod(), this.buildParameterInjections(builderMethod.getParameters()));
        }
        return builderMethodInjection;
    }

    protected final Iterable<ThriftFieldMetadata> buildFieldInjections() {
        ImmutableListMultimap fieldsById = Multimaps.index(this.fields, FieldMetadata.getThriftFieldId());
        return Iterables.transform(fieldsById.asMap().values(), (Function)new Function<Collection<FieldMetadata>, ThriftFieldMetadata>(){

            public ThriftFieldMetadata apply(Collection<FieldMetadata> input) {
                Preconditions.checkArgument((!input.isEmpty() ? 1 : 0) != 0, (Object)"input is empty");
                return AbstractThriftMetadataBuilder.this.buildField(input);
            }
        });
    }

    protected final List<ThriftMethodInjection> buildMethodInjections() {
        return Lists.transform(this.methodInjections, (Function)new Function<MethodInjection, ThriftMethodInjection>(){

            public ThriftMethodInjection apply(MethodInjection injection) {
                return new ThriftMethodInjection(injection.getMethod(), AbstractThriftMetadataBuilder.this.buildParameterInjections(injection.getParameters()));
            }
        });
    }

    protected final List<ThriftParameterInjection> buildParameterInjections(List<ParameterInjection> parameters) {
        return Lists.transform(parameters, (Function)new Function<ParameterInjection, ThriftParameterInjection>(){

            public ThriftParameterInjection apply(ParameterInjection injection) {
                return new ThriftParameterInjection(injection.getId(), injection.getName(), injection.getParameterIndex(), injection.getJavaType());
            }
        });
    }
}

