/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.metadata.FieldKind;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.lang.reflect.Type;
import javax.annotation.Nullable;

abstract class FieldMetadata {
    private Short id;
    private String name;
    private ThriftField.Requiredness requiredness;
    private final FieldKind type;

    protected FieldMetadata(ThriftField annotation, FieldKind type) {
        this.type = type;
        switch (type) {
            case THRIFT_FIELD: {
                if (annotation == null) break;
                if (annotation.value() != Short.MIN_VALUE) {
                    this.id = annotation.value();
                }
                if (!annotation.name().isEmpty()) {
                    this.name = annotation.name();
                }
                this.requiredness = (ThriftField.Requiredness)Preconditions.checkNotNull((Object)annotation.requiredness());
                break;
            }
            case THRIFT_UNION_ID: {
                this.id = Short.MIN_VALUE;
                this.name = "_union_id";
                break;
            }
            default: {
                throw new IllegalArgumentException("Encountered field metadata type " + (Object)((Object)type));
            }
        }
    }

    public Short getId() {
        return this.id;
    }

    public void setId(short id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FieldKind getType() {
        return this.type;
    }

    public abstract Type getJavaType();

    public abstract String extractName();

    static <T extends FieldMetadata> Function<T, Optional<Short>> getThriftFieldId() {
        return new Function<T, Optional<Short>>(){

            public Optional<Short> apply(@Nullable T input) {
                if (input == null) {
                    return Optional.absent();
                }
                Short value = ((FieldMetadata)input).getId();
                return Optional.fromNullable((Object)value);
            }
        };
    }

    static <T extends FieldMetadata> Function<T, String> getThriftFieldName() {
        return new Function<T, String>(){

            public String apply(@Nullable T input) {
                if (input == null) {
                    return null;
                }
                return ((FieldMetadata)input).getName();
            }
        };
    }

    static <T extends FieldMetadata> Function<T, String> getOrExtractThriftFieldName() {
        return new Function<T, String>(){

            public String apply(@Nullable T input) {
                if (input == null) {
                    return null;
                }
                String name = ((FieldMetadata)input).getName();
                if (name == null) {
                    name = ((FieldMetadata)input).extractName();
                }
                if (name == null) {
                    throw new NullPointerException(String.valueOf("name is null"));
                }
                return name;
            }
        };
    }

    static <T extends FieldMetadata> Function<T, String> extractThriftFieldName() {
        return new Function<T, String>(){

            public String apply(@Nullable T input) {
                if (input == null) {
                    return null;
                }
                return ((FieldMetadata)input).extractName();
            }
        };
    }

    static <T extends FieldMetadata> Function<T, ThriftField.Requiredness> getThriftFieldRequiredness() {
        return new Function<T, ThriftField.Requiredness>(){

            @Nullable
            public ThriftField.Requiredness apply(@Nullable T input) {
                return ((FieldMetadata)input).getRequiredness();
            }
        };
    }

    public static Predicate<FieldMetadata> isType(final FieldKind type) {
        return new Predicate<FieldMetadata>(){

            public boolean apply(FieldMetadata fieldMetadata) {
                return fieldMetadata.getType() == type;
            }
        };
    }

    public ThriftField.Requiredness getRequiredness() {
        return this.requiredness;
    }

    public void setRequiredness(ThriftField.Requiredness requiredness) {
        this.requiredness = requiredness;
    }
}

