/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftConstructorInjection;
import com.facebook.swift.codec.metadata.ThriftExtraction;
import com.facebook.swift.codec.metadata.ThriftFieldExtractor;
import com.facebook.swift.codec.metadata.ThriftInjection;
import com.facebook.swift.codec.metadata.ThriftMethodExtractor;
import com.facebook.swift.codec.metadata.ThriftMethodInjection;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.codec.metadata.TypeCoercion;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftFieldMetadata {
    private final short id;
    private final ThriftType thriftType;
    private final String name;
    private final FieldKind fieldKind;
    private final List<ThriftInjection> injections;
    private final Optional<ThriftConstructorInjection> constructorInjection;
    private final Optional<ThriftMethodInjection> methodInjection;
    private final Optional<ThriftExtraction> extraction;
    private final Optional<TypeCoercion> coercion;
    private final ImmutableList<String> documentation;
    private final ThriftField.Requiredness requiredness;

    public ThriftFieldMetadata(short id, ThriftField.Requiredness requiredness, ThriftType thriftType, String name, FieldKind fieldKind, List<ThriftInjection> injections, Optional<ThriftConstructorInjection> constructorInjection, Optional<ThriftMethodInjection> methodInjection, Optional<ThriftExtraction> extraction, Optional<TypeCoercion> coercion) {
        this.requiredness = requiredness;
        this.thriftType = (ThriftType)Preconditions.checkNotNull((Object)thriftType, (Object)"thriftType is null");
        this.fieldKind = (FieldKind)((Object)Preconditions.checkNotNull((Object)((Object)fieldKind), (Object)"type is null"));
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.injections = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(injections, (Object)"injections is null")));
        this.constructorInjection = (Optional)Preconditions.checkNotNull(constructorInjection, (Object)"constructorInjection is null");
        this.methodInjection = (Optional)Preconditions.checkNotNull(methodInjection, (Object)"methodInjection is null");
        this.extraction = (Optional)Preconditions.checkNotNull(extraction, (Object)"extraction is null");
        this.coercion = (Optional)Preconditions.checkNotNull(coercion, (Object)"coercion is null");
        switch (fieldKind) {
            case THRIFT_FIELD: {
                Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"id is negative");
                break;
            }
            case THRIFT_UNION_ID: {
                Preconditions.checkArgument((id == Short.MIN_VALUE ? 1 : 0) != 0, (Object)"thrift union id must be Short.MIN_VALUE");
            }
        }
        Preconditions.checkArgument((!injections.isEmpty() || extraction.isPresent() || constructorInjection.isPresent() || methodInjection.isPresent() ? 1 : 0) != 0, (Object)"A thrift field must have an injection or extraction point");
        this.id = id;
        if (extraction.isPresent()) {
            if (extraction.get() instanceof ThriftFieldExtractor) {
                ThriftFieldExtractor e = (ThriftFieldExtractor)extraction.get();
                this.documentation = ThriftCatalog.getThriftDocumentation(e.getField());
            } else if (extraction.get() instanceof ThriftMethodExtractor) {
                ThriftMethodExtractor e = (ThriftMethodExtractor)extraction.get();
                this.documentation = ThriftCatalog.getThriftDocumentation(e.getMethod());
            } else {
                this.documentation = ImmutableList.of();
            }
        } else {
            this.documentation = ImmutableList.of();
        }
    }

    public short getId() {
        return this.id;
    }

    public ThriftType getThriftType() {
        return this.thriftType;
    }

    public ThriftField.Requiredness getRequiredness() {
        return this.requiredness;
    }

    public String getName() {
        return this.name;
    }

    public FieldKind getType() {
        return this.fieldKind;
    }

    public boolean isInternal() {
        switch (this.getType()) {
            case THRIFT_FIELD: {
                return false;
            }
        }
        return true;
    }

    public boolean isReadOnly() {
        return this.injections.isEmpty() && !this.constructorInjection.isPresent() && !this.methodInjection.isPresent();
    }

    public boolean isWriteOnly() {
        return !this.extraction.isPresent();
    }

    public List<ThriftInjection> getInjections() {
        return this.injections;
    }

    public Optional<ThriftConstructorInjection> getConstructorInjection() {
        return this.constructorInjection;
    }

    public Optional<ThriftMethodInjection> getMethodInjection() {
        return this.methodInjection;
    }

    public Optional<ThriftExtraction> getExtraction() {
        return this.extraction;
    }

    public Optional<TypeCoercion> getCoercion() {
        return this.coercion;
    }

    public ImmutableList<String> getDocumentation() {
        return this.documentation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThriftFieldMetadata");
        sb.append("{id=").append(this.id);
        sb.append(", thriftType=").append(this.thriftType);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", fieldKind=").append((Object)this.fieldKind);
        sb.append(", injections=").append(this.injections);
        sb.append(", constructorInjection=").append(this.constructorInjection);
        sb.append(", methodInjection=").append(this.methodInjection);
        sb.append(", extraction=").append(this.extraction);
        sb.append(", coercion=").append(this.coercion);
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.thriftType, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThriftFieldMetadata other = (ThriftFieldMetadata)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.thriftType, other.thriftType) && Objects.equals(this.name, other.name);
    }

    public static Function<ThriftFieldMetadata, Short> getIdGetter() {
        return new Function<ThriftFieldMetadata, Short>(){

            public Short apply(ThriftFieldMetadata metadata) {
                return metadata.getId();
            }
        };
    }

    public static Predicate<ThriftFieldMetadata> isTypePredicate(final FieldKind type) {
        return new Predicate<ThriftFieldMetadata>(){

            public boolean apply(ThriftFieldMetadata fieldMetadata) {
                return fieldMetadata.getType() == type;
            }
        };
    }
}

