/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.metadata.Extractor;
import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.ReflectionHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class MethodExtractor
extends Extractor {
    private final Type thriftStructType;
    private final Method method;

    public MethodExtractor(Type thriftStructType, Method method, ThriftField annotation, FieldKind fieldKind) {
        super(annotation, fieldKind);
        this.thriftStructType = thriftStructType;
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public String extractName() {
        return ReflectionHelper.extractFieldName(this.method.getName());
    }

    @Override
    public Type getJavaType() {
        return ReflectionHelper.resolveFieldType(this.thriftStructType, this.method.getGenericReturnType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MethodExtractor");
        sb.append("{method=").append(this.method);
        sb.append('}');
        return sb.toString();
    }
}

