/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.ThriftExtraction;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftFieldExtractor
implements ThriftExtraction {
    private final short id;
    private final String name;
    private final Field field;
    private final FieldKind fieldKind;
    private final Class<?> type;

    public ThriftFieldExtractor(short fieldId, String fieldName, FieldKind fieldKind, Field field, Type fieldType) {
        this.name = (String)Preconditions.checkNotNull((Object)fieldName, (Object)"name is null");
        this.field = (Field)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.fieldKind = (FieldKind)((Object)Preconditions.checkNotNull((Object)((Object)fieldKind), (Object)"type is null"));
        this.type = TypeToken.of((Type)((Type)Preconditions.checkNotNull((Object)fieldType, (Object)"structType is null"))).getRawType();
        switch (fieldKind) {
            case THRIFT_FIELD: {
                Preconditions.checkArgument((fieldId >= 0 ? 1 : 0) != 0, (Object)"fieldId is negative");
                break;
            }
            case THRIFT_UNION_ID: {
                Preconditions.checkArgument((fieldId == Short.MIN_VALUE ? 1 : 0) != 0, (Object)"fieldId must be Short.MIN_VALUE for thrift_union_id");
            }
        }
        this.id = fieldId;
    }

    @Override
    public FieldKind getFieldKind() {
        return this.fieldKind;
    }

    @Override
    public short getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isGeneric() {
        return this.field.getType() != this.field.getGenericType();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThriftFieldExtractor");
        sb.append("{id=").append(this.id);
        sb.append(", name=").append(this.name);
        sb.append(", fieldKind=").append((Object)this.fieldKind);
        sb.append(", field=").append(this.field.getDeclaringClass().getSimpleName()).append(".").append(this.field.getName());
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }
}

