/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class Ack<T> {
    private Integer cmdSn;
    private int deviceId;
    private String deviceMac;
    private String item;
    private T value;
    private Status status;
    private String statusMessage;
    private String exception;

    public String message() {
        Preconditions.checkArgument((null != this.status ? 1 : 0) != 0, (Object)"status field is null");
        StringBuffer buffer = new StringBuffer(String.format("device%d@%d:%s", this.deviceId, this.cmdSn, this.status.name()));
        switch (this.status) {
            case ERROR: 
            case REJECTED: {
                if (Strings.isNullOrEmpty((String)this.statusMessage)) break;
                buffer.append(":").append(this.statusMessage);
                break;
            }
            case PROGRESS: {
                if (this.value instanceof Number) {
                    buffer.append(":finished %").append(((Number)this.value).intValue());
                }
                if (Strings.isNullOrEmpty((String)this.statusMessage)) break;
                buffer.append(":").append(this.statusMessage);
                break;
            }
        }
        return buffer.toString();
    }

    public Integer getCmdSn() {
        return this.cmdSn;
    }

    public Ack<T> setCmdSn(Integer cmdSn) {
        this.cmdSn = cmdSn;
        return this;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public Ack<T> setDeviceId(int deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public String getDeviceMac() {
        return this.deviceMac;
    }

    public Ack<T> setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
        return this;
    }

    public String getItem() {
        return this.item;
    }

    public Ack<T> setItem(String item) {
        this.item = item;
        return this;
    }

    public T getValue() {
        return this.value;
    }

    public Ack<T> setValue(T value) {
        this.value = value;
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    public Ack<T> setStatus(Status status) {
        this.status = status;
        return this;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Ack<T> setStatusMessage(String errorMessage) {
        this.statusMessage = errorMessage;
        return this;
    }

    public String getException() {
        return this.exception;
    }

    public Ack<T> setException(String exception) {
        this.exception = exception;
        return this;
    }

    public Ack<T> writeError(Throwable e) {
        return this.setStatus(Status.ERROR).setStatusMessage(e.getMessage()).setException(e.getClass().getName());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Ack [");
        if (this.cmdSn != null) {
            builder.append("cmdSn=");
            builder.append(this.cmdSn);
            builder.append(", ");
        }
        builder.append("deviceId=");
        builder.append(this.deviceId);
        builder.append(", ");
        if (this.deviceMac != null) {
            builder.append("deviceMac=");
            builder.append(this.deviceMac);
            builder.append(", ");
        }
        if (this.item != null) {
            builder.append("item=");
            builder.append(this.item);
            builder.append(", ");
        }
        if (this.value != null) {
            builder.append("value=");
            builder.append(this.value);
            builder.append(", ");
        }
        if (this.status != null) {
            builder.append("status=");
            builder.append((Object)this.status);
            builder.append(", ");
        }
        if (this.statusMessage != null) {
            builder.append("statusMessage=");
            builder.append(this.statusMessage);
            builder.append(", ");
        }
        if (this.exception != null) {
            builder.append("exception=");
            builder.append(this.exception);
        }
        builder.append("]");
        return builder.toString();
    }

    public static enum Status {
        OK,
        UNSUPPORTED,
        ERROR,
        TIMEOUT,
        REJECTED,
        ACCEPTED,
        PROGRESS,
        CANCELED;

    }
}

