/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gu.dtalk.BaseItem;
import gu.dtalk.BaseOption;
import gu.dtalk.ICmdImmediateAdapter;
import gu.dtalk.ICmdInteractiveAdapter;
import gu.dtalk.ICmdInteractiveStatusListener;
import gu.dtalk.ICmdUnionAdapter;
import gu.dtalk.ItemType;
import gu.dtalk.exception.CmdExecutionException;
import gu.dtalk.exception.InteractiveCmdStartException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CmdItem
extends BaseItem {
    private static final Function<BaseItem, BaseOption<Object>> TO_OPTION = new Function<BaseItem, BaseOption<Object>>(){

        public BaseOption<Object> apply(BaseItem input) {
            return (BaseOption)input;
        }
    };
    private static final Function<BaseOption<?>, BaseItem> TO_ITEM = new Function<BaseOption<?>, BaseItem>(){

        public BaseItem apply(BaseOption<?> input) {
            return input;
        }
    };
    private static final Function<BaseItem, Object> TO_VALUE = new Function<BaseItem, Object>(){

        public Object apply(BaseItem input) {
            return ((BaseOption)input).fetch();
        }
    };
    @JSONField(serialize=false, deserialize=false)
    private ICmdUnionAdapter cmdAdapter;
    private Boolean canceled;
    private boolean needReset;

    @Override
    public final boolean isContainer() {
        return true;
    }

    @Override
    public final ItemType getCatalog() {
        return ItemType.CMD;
    }

    @JSONField(serialize=false, deserialize=false)
    public List<BaseOption<Object>> getParameters() {
        return Lists.transform(this.getChilds(), TO_OPTION);
    }

    @JSONField(serialize=false, deserialize=false)
    public void setParameters(List<BaseOption<?>> parameters) {
        this.items.clear();
        this.addParameters(parameters);
    }

    public CmdItem addParameters(BaseOption<?> ... parameter) {
        return this.addParameters(Arrays.asList(parameter));
    }

    public CmdItem addParameters(Collection<BaseOption<?>> parameters) {
        this.addChilds(Collections2.transform(parameters, TO_ITEM));
        return this;
    }

    public ICmdUnionAdapter getCmdAdapter() {
        return this.cmdAdapter;
    }

    public CmdItem setCmdAdapter(ICmdUnionAdapter cmdAdapter) {
        this.cmdAdapter = cmdAdapter;
        return this;
    }

    public CmdItem setInteractiveCmdAdapter(ICmdInteractiveAdapter cmdAdapter) {
        this.cmdAdapter = cmdAdapter;
        return this;
    }

    public CmdItem setImmediateCmdAdapter(ICmdImmediateAdapter cmdAdapter) {
        this.cmdAdapter = cmdAdapter;
        return this;
    }

    public static final <T> T cast(Object value, Type type) {
        return (T)TypeUtils.cast((Object)value, (Type)type, (ParserConfig)ParserConfig.getGlobalInstance());
    }

    public CmdItem updateParameter(Map<String, ?> parameters) {
        parameters = (Map)MoreObjects.firstNonNull(parameters, Collections.emptyMap());
        for (BaseOption<Object> param : this.getParameters()) {
            if (!parameters.containsKey(param.getName())) continue;
            Object value = CmdItem.cast(parameters.get(param.getName()), param.javaType());
            param.updateFrom(value);
        }
        return this;
    }

    private Map<String, Object> checkRequired(Map<String, Object> input) {
        for (BaseOption<Object> param : this.getParameters()) {
            Preconditions.checkArgument((!param.isRequired() || input.containsKey(param.getName()) ? 1 : 0) != 0, (String)"MISS REQUIRED PARAM %s", (Object)param.getName());
        }
        return input;
    }

    public final Object runImmediateCmd() throws CmdExecutionException {
        return this.runImmediateCmd(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Object runImmediateCmd(Map<String, ?> parameters) throws CmdExecutionException {
        Preconditions.checkState((boolean)(this.cmdAdapter instanceof ICmdImmediateAdapter), (String)"type of cmdAdapter must be %s", (Object)ICmdImmediateAdapter.class.getSimpleName());
        LinkedHashMap linkedHashMap = this.items;
        synchronized (linkedHashMap) {
            Object object;
            if (this.cmdAdapter == null) return null;
            this.updateParameter(parameters);
            try {
                Map objParams = Maps.transformValues((Map)this.items, TO_VALUE);
                object = ((ICmdImmediateAdapter)this.cmdAdapter).apply(this.checkRequired(objParams));
                this.reset();
            }
            catch (Throwable throwable) {
                this.reset();
                throw throwable;
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startInteractiveCmd(ICmdInteractiveStatusListener statusListener) throws InteractiveCmdStartException {
        Preconditions.checkState((boolean)(this.cmdAdapter instanceof ICmdInteractiveAdapter), (String)"type of cmdAdapter must be %s", (Object)ICmdInteractiveAdapter.class.getSimpleName());
        LinkedHashMap linkedHashMap = this.items;
        synchronized (linkedHashMap) {
            if (this.cmdAdapter != null) {
                try {
                    Map objParams = Maps.transformValues((Map)this.items, TO_VALUE);
                    ((ICmdInteractiveAdapter)this.cmdAdapter).apply(this.checkRequired(objParams), (ICmdInteractiveStatusListener)Preconditions.checkNotNull((Object)statusListener, (Object)"statusListener is null"));
                }
                finally {
                    this.reset();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void startInteractiveCmd(Map<String, ?> parameters, ICmdInteractiveStatusListener statusListener) throws InteractiveCmdStartException {
        Preconditions.checkState((boolean)(this.cmdAdapter instanceof ICmdInteractiveAdapter), (String)"type of cmdAdapter must be %s", (Object)ICmdInteractiveAdapter.class.getSimpleName());
        LinkedHashMap linkedHashMap = this.items;
        synchronized (linkedHashMap) {
            if (this.cmdAdapter != null) {
                this.updateParameter(parameters);
                try {
                    Map objParams = Maps.transformValues((Map)this.items, TO_VALUE);
                    ((ICmdInteractiveAdapter)this.cmdAdapter).apply(this.checkRequired(objParams), (ICmdInteractiveStatusListener)Preconditions.checkNotNull((Object)statusListener, (Object)"statusListener is null"));
                }
                finally {
                    this.reset();
                }
            }
        }
    }

    public final void cancelInteractiveCmd() {
        Preconditions.checkState((boolean)(this.cmdAdapter instanceof ICmdInteractiveAdapter), (String)"type of cmdAdapter must be %s", (Object)ICmdInteractiveAdapter.class.getSimpleName());
        ((ICmdInteractiveAdapter)this.cmdAdapter).cancel();
    }

    public <T> BaseOption<T> getParameter(String name) {
        return (BaseOption)this.getChild(name);
    }

    public CmdItem reset() {
        for (BaseOption<Object> item : this.getParameters()) {
            item.setValue(null);
        }
        return this;
    }

    public Boolean getCanceled() {
        return this.canceled;
    }

    public void setCanceled(Boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isNeedReset() {
        return this.needReset;
    }

    public CmdItem setNeedReset(boolean needReset) {
        this.needReset = needReset;
        return this;
    }

    @JSONField(serialize=false, deserialize=false)
    public boolean isInteractiveCmd() {
        return this.cmdAdapter instanceof ICmdInteractiveAdapter;
    }
}

