/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import gu.dtalk.BaseItem;
import gu.dtalk.BaseOption;
import gu.dtalk.CmdItem;
import gu.dtalk.ItemType;
import gu.dtalk.OptionType;
import net.gdface.utils.FaceUtilits;

public class CommonUtils {
    public static String getAckChannel(String mac) {
        return mac + "_dtalk_ack";
    }

    public static String getAckChannel(byte[] mac) {
        return CommonUtils.getAckChannel(FaceUtilits.toHex((byte[])mac));
    }

    public static String getConnChannel(String mac) {
        return mac + "_dtalk_connect";
    }

    public static String getConnChannel(byte[] mac) {
        return CommonUtils.getConnChannel(FaceUtilits.toHex((byte[])mac));
    }

    private static boolean hasField(Object resp, String name) {
        return resp instanceof JSONObject && ((JSONObject)resp).containsKey((Object)name);
    }

    public static boolean isAck(Object resp) {
        return resp instanceof JSONObject && CommonUtils.hasField((JSONObject)resp, "status");
    }

    public static boolean isItem(Object resp) {
        return CommonUtils.hasField(resp, "name") && CommonUtils.hasField(resp, "path") && CommonUtils.hasField(resp, "catalog");
    }

    public static CmdItem makeQuit() {
        CmdItem item = new CmdItem();
        item.setName("quit");
        return item;
    }

    public static CmdItem makeBack() {
        CmdItem item = new CmdItem();
        item.setName("back");
        return item;
    }

    public static boolean isBack(BaseItem item) {
        return item instanceof BaseItem && "back".equals(item.getName());
    }

    public static boolean isRoot(JSONObject item) {
        return item instanceof JSONObject && "/".equals(item.getString("path"));
    }

    public static boolean isRoot(BaseItem item) {
        return item instanceof BaseItem && null == item.getParent();
    }

    public static boolean isQuit(BaseItem item) {
        return item instanceof BaseItem && "quit".equals(item.getName());
    }

    public static boolean isQuit(JSONObject item) {
        return item instanceof JSONObject && "quit".equals(item.getString("name"));
    }

    public static boolean isQuit(JSONObject item, BaseItem start) {
        return CommonUtils.isQuit(CommonUtils.normalize(item, start));
    }

    public static boolean isQuit(Object item) {
        return CommonUtils.isQuit((BaseItem)item) || CommonUtils.isQuit((JSONObject)item);
    }

    public static boolean isImage(JSONObject item) {
        return item == null ? false : OptionType.IMAGE.name().equals(item.getString("type"));
    }

    public static boolean isImage(JSONObject item, BaseItem start) {
        return CommonUtils.isImage(CommonUtils.normalize(item, start));
    }

    public static JSONObject normalize(JSONObject jsonObject, BaseItem start) {
        if (null != jsonObject && null != start) {
            BaseItem node;
            String name = jsonObject.getString("name");
            String path = jsonObject.getString("path");
            Preconditions.checkArgument((name != null || path != null ? 1 : 0) != 0, (Object)"NOT DEFINED path or name");
            if (path != null) {
                node = start.findChecked(path);
            } else if (name != null) {
                node = start.findChecked(name);
            } else {
                throw new IllegalArgumentException("NOT DEFINED path or name");
            }
            if (jsonObject.containsKey((Object)"catalog")) {
                Preconditions.checkArgument((boolean)node.getCatalog().equals(jsonObject.getObject("catalog", ItemType.class)), (String)"MISMATCH CATALOG %s", (Object)node.getPath());
            } else {
                jsonObject.fluentPut("catalog", (Object)node.getCatalog());
            }
            if (node instanceof BaseOption) {
                BaseOption opt = (BaseOption)node;
                if (jsonObject.containsKey((Object)"type")) {
                    Preconditions.checkArgument((boolean)opt.getType().equals(jsonObject.getObject("type", OptionType.class)), (String)"MISMATCH TYPE %s", (Object)node.getPath());
                } else {
                    jsonObject.fluentPut("type", (Object)opt.getType());
                }
            }
            if (name == null) {
                jsonObject.fluentPut("name", (Object)node.getName());
            }
            for (Object child : (JSONArray)MoreObjects.firstNonNull((Object)jsonObject.getJSONArray("childs"), (Object)new JSONArray())) {
                Preconditions.checkArgument((boolean)(child instanceof JSONObject), (String)"INVALID JSON FORMAT FOR CHILD OF %s", (Object)node.getPath());
                CommonUtils.normalize((JSONObject)child, node);
            }
        }
        return jsonObject;
    }
}

