/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.google.common.base.Preconditions;
import gu.dtalk.Ack;
import gu.simplemq.IMessageAdapter;
import gu.simplemq.exceptions.SmqUnsubscribeException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public interface IAckAdapter<T>
extends IMessageAdapter<Ack<T>> {
    public static final long DEFAULT_DURATION = 60000L;

    public IAckAdapter<T> setClientNum(long var1);

    public long getDuration();

    public boolean isFinished();

    public static abstract class BaseAdapter<T>
    implements IAckAdapter<T> {
        private final AtomicLong clientNum = new AtomicLong(-1L);
        private long duration = 0L;
        private long ackCount = 0L;
        private final AtomicBoolean isFinished = new AtomicBoolean(Boolean.FALSE);

        public BaseAdapter() {
            this(60000L, TimeUnit.MILLISECONDS);
        }

        public BaseAdapter(long duration, TimeUnit unit) {
            this.setDuration(duration, unit);
        }

        protected void doOnTimeout() {
        }

        protected void doOnZeroClient() {
        }

        protected void doOnSubscribe(Ack<T> t) {
        }

        protected final long getClientNum() {
            return this.clientNum.get();
        }

        protected final long getAckCount() {
            return this.ackCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void doOnFinished() {
            BaseAdapter baseAdapter = this;
            synchronized (baseAdapter) {
                Preconditions.checkState((boolean)this.isFinished.compareAndSet(false, true), (Object)"invalid status of isFinished");
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onSubscribe(Ack<T> t) throws SmqUnsubscribeException {
            if (t.getStatus() == Ack.Status.TIMEOUT) {
                if (this.clientNum.get() == 0L) {
                    this.doOnZeroClient();
                } else {
                    this.doOnTimeout();
                }
                this.doOnFinished();
            } else {
                try {
                    this.doOnSubscribe(t);
                }
                finally {
                    if (++this.ackCount == this.clientNum.get()) {
                        this.doOnFinished();
                        throw new SmqUnsubscribeException(true);
                    }
                }
            }
        }

        @Override
        public BaseAdapter<T> setClientNum(long clientNum) {
            Preconditions.checkArgument((clientNum >= 0L ? 1 : 0) != 0, (String)"INVALID clientNum %s", (long)clientNum);
            Preconditions.checkState((boolean)this.clientNum.compareAndSet(-1L, clientNum), (Object)"clientNum can be set once only");
            return this;
        }

        @Override
        public final long getDuration() {
            return this.duration;
        }

        @Override
        public boolean isFinished() {
            return this.isFinished.get() || this.ackCount == this.clientNum.get();
        }

        public final BaseAdapter<T> setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public final BaseAdapter<T> setDuration(long duration, TimeUnit unit) {
            return this.setDuration(TimeUnit.MILLISECONDS.convert(duration, (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit is null"))));
        }

        public final BaseAdapter<T> setExpire(long expire) {
            return this.setDuration(expire - System.currentTimeMillis());
        }

        public final BaseAdapter<T> setExpire(Date expire) {
            return this.setDuration(expire.getTime() - System.currentTimeMillis());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void waitFinished() throws InterruptedException {
            BaseAdapter baseAdapter = this;
            synchronized (baseAdapter) {
                while (!this.isFinished()) {
                    this.wait(200L);
                }
            }
        }

        public final synchronized BaseAdapter<T> reset() {
            this.clientNum.set(-1L);
            this.duration = 0L;
            this.ackCount = 0L;
            this.isFinished.set(false);
            return this;
        }
    }
}

