/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import gu.dtalk.BaseBinary;
import gu.dtalk.OptionType;
import java.net.InetAddress;
import net.gdface.utils.NetworkUtil;

public class IPv4Option
extends BaseBinary {
    public static final Predicate<byte[]> VALIDATOR = new Predicate<byte[]>(){

        public boolean apply(byte[] input) {
            return input != null && input.length == 4;
        }
    };

    public IPv4Option() {
        this.setValidator(VALIDATOR);
    }

    @Override
    public OptionType getType() {
        return OptionType.IP;
    }

    @Override
    public String contentOfValue() {
        if (this.getValue() == null) {
            return super.contentOfValue();
        }
        return NetworkUtil.formatIp((byte[])((byte[])this.getValue()));
    }

    public IPv4Option asValue(InetAddress input) {
        try {
            this.setValue(input.getAddress());
            return this;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public IPv4Option asDefaultValue(InetAddress input) {
        try {
            this.setDefaultValue(input.getAddress());
            return this;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

