/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import gu.dtalk.BaseItem;
import gu.dtalk.CmdItem;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;

public class ItemBuilder<T extends BaseItem> {
    protected final T item;

    public ItemBuilder(T item) {
        this.item = item;
    }

    public ItemBuilder<T> name(String name) {
        ((BaseItem)this.item).setName(name);
        return this;
    }

    public ItemBuilder<T> disable(boolean disable) {
        ((BaseItem)this.item).setDisable(disable);
        return this;
    }

    public ItemBuilder<T> disable() {
        return this.disable(true);
    }

    public ItemBuilder<T> hide(boolean hide) {
        ((BaseItem)this.item).setHide(hide);
        return this;
    }

    public ItemBuilder<T> hide() {
        return this.hide(true);
    }

    public ItemBuilder<T> needReset(boolean needReset) {
        if (this.item instanceof CmdItem) {
            ((CmdItem)this.item).setNeedReset(needReset);
        }
        return this;
    }

    public ItemBuilder<T> needReset() {
        return this.needReset(true);
    }

    public ItemBuilder<T> description(String description) {
        ((BaseItem)this.item).setDescription(description);
        return this;
    }

    public ItemBuilder<T> uiName(String uiName) {
        ((BaseItem)this.item).setUiName(uiName);
        return this;
    }

    public ItemBuilder<T> childs(List<BaseItem> childs) {
        Preconditions.checkState((boolean)((BaseItem)this.item).isContainer(), (String)"%s isn't container", (Object)this.item.getClass().getSimpleName());
        ((BaseItem)this.item).setChilds(childs);
        return this;
    }

    public ItemBuilder<T> addChilds(BaseItem ... childs) {
        Preconditions.checkState((boolean)((BaseItem)this.item).isContainer(), (String)"%s isn't container", (Object)this.item.getClass().getSimpleName());
        ((BaseItem)this.item).addChilds(childs);
        return this;
    }

    public ItemBuilder<T> addChilds(Collection<BaseItem> childs) {
        Preconditions.checkState((boolean)((BaseItem)this.item).isContainer(), (String)"%s isn't container", (Object)this.item.getClass().getSimpleName());
        ((BaseItem)this.item).addChilds(childs);
        return this;
    }

    public T instance() {
        return this.item;
    }

    public static <T extends BaseItem> ItemBuilder<T> builder(T instance) {
        return new ItemBuilder<BaseItem>((BaseItem)Preconditions.checkNotNull(instance, (Object)"instance is null"));
    }

    public static <T extends BaseItem> ItemBuilder<T> builder(Class<T> type) {
        Preconditions.checkArgument((!Modifier.isAbstract(type.getModifiers()) ? 1 : 0) != 0, (String)"%s is a abstract class", (Object)type.getName());
        try {
            return new ItemBuilder<BaseItem>((BaseItem)type.newInstance());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

