/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import gu.dtalk.BaseItem;
import gu.dtalk.BaseOption;
import gu.dtalk.CmdItem;
import gu.dtalk.CommonUtils;
import gu.dtalk.ItemType;
import gu.dtalk.exception.CmdExecutionException;
import gu.dtalk.exception.UnsupportCmdException;
import java.util.Collections;
import java.util.Map;

public class MenuItem
extends BaseItem {
    public MenuItem() {
        this.items.clear();
        CmdItem back = CommonUtils.makeBack();
        this.items.put(back.getName(), back);
    }

    @Override
    public final boolean isContainer() {
        return true;
    }

    @Override
    public final ItemType getCatalog() {
        return ItemType.MENU;
    }

    public Object runCmd(String cmdpath, Map<String, ?> parameters) throws UnsupportCmdException, CmdExecutionException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cmdpath) ? 1 : 0) != 0, (Object)"cmd's path is null or empty");
        parameters = (Map)MoreObjects.firstNonNull(parameters, Collections.emptyMap());
        CmdItem cmd = this.findCmd(cmdpath);
        if (cmd == null) {
            throw new UnsupportCmdException(cmdpath + " is not a cmd item");
        }
        return cmd.runImmediateCmd(parameters);
    }

    public MenuItem readonlyOption(String optpath, boolean readonly) {
        BaseOption option = this.findOption(optpath);
        if (option != null) {
            option.setReadOnly(readonly);
        }
        return this;
    }

    public MenuItem disableItem(String optpath, boolean disable) {
        BaseItem option = this.find(optpath);
        if (option != null) {
            option.setDisable(disable);
        }
        return this;
    }

    public <T> T fetchOption(String optpath) {
        BaseOption option = this.findOption(optpath);
        if (option != null) {
            return option.fetch();
        }
        return null;
    }

    public <T> T optionValueOf(String optpath) {
        BaseOption option = this.findOption(optpath);
        if (option != null) {
            return option.getValue();
        }
        return null;
    }

    public <T> MenuItem updateValueOf(String optpath, T value) {
        BaseOption<T> option = this.findOption(optpath);
        if (option != null) {
            option.updateFrom(value);
        }
        return this;
    }
}

