/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import gu.dtalk.FormatedValue;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.gdface.utils.TypeUtils;

public class Ack<T> {
    private static boolean traceEnable = false;
    private Integer cmdSn;
    private int deviceId;
    private String deviceMac;
    private String item;
    private T value;
    private String valueType;
    private String howtodo;
    private Status status;
    private String statusMessage;
    private String exception;
    private String trace;

    public String message() {
        Preconditions.checkArgument((null != this.status ? 1 : 0) != 0, (Object)"status field is null");
        StringBuffer buffer = new StringBuffer(String.format("device%d@%d:%s", this.deviceId, this.cmdSn, this.status.name()));
        switch (this.status) {
            case ERROR: 
            case REJECTED: {
                if (Strings.isNullOrEmpty((String)this.statusMessage)) break;
                buffer.append(":").append(this.statusMessage);
                break;
            }
            case PROGRESS: {
                if (this.value instanceof Number) {
                    buffer.append(":finished %").append(((Number)this.value).intValue());
                }
                if (Strings.isNullOrEmpty((String)this.statusMessage)) break;
                buffer.append(":").append(this.statusMessage);
                break;
            }
        }
        return buffer.toString();
    }

    public Integer getCmdSn() {
        return this.cmdSn;
    }

    public Ack<T> setCmdSn(Integer cmdSn) {
        this.cmdSn = cmdSn;
        return this;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public Ack<T> setDeviceId(int deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public String getDeviceMac() {
        return this.deviceMac;
    }

    public Ack<T> setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
        return this;
    }

    public String getItem() {
        return this.item;
    }

    public Ack<T> setItem(String item) {
        this.item = item;
        return this;
    }

    public T getValue() {
        return this.value;
    }

    public Ack<T> setValue(Object value) {
        if (value instanceof FormatedValue) {
            FormatedValue v = (FormatedValue)value;
            this.value = v.value;
            this.setValueType(v.contentType);
            this.setHowtodo(v.howtodo);
            return this;
        }
        this.value = value;
        this.setHowtodo(null);
        return this.setValueType(value != null ? TypeUtils.getTypeName(value.getClass(), (boolean)false) : null);
    }

    public String getValueType() {
        return this.valueType;
    }

    public Ack<T> setValueType(String valueClass) {
        this.valueType = valueClass;
        return this;
    }

    public String getHowtodo() {
        return this.howtodo;
    }

    public void setHowtodo(String howtodo) {
        this.howtodo = howtodo;
    }

    public Status getStatus() {
        return this.status;
    }

    public Ack<T> setStatus(Status status) {
        this.status = status;
        return this;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Ack<T> setStatusMessage(String errorMessage) {
        this.statusMessage = errorMessage;
        return this;
    }

    public String getException() {
        return this.exception;
    }

    public Ack<T> setException(String exception) {
        this.exception = exception;
        return this;
    }

    public String getTrace() {
        return this.trace;
    }

    public Ack<T> setTrace(String trace) {
        this.trace = trace;
        return this;
    }

    public Ack<T> writeError(Throwable e) {
        if (traceEnable) {
            StringWriter write = new StringWriter(256);
            PrintWriter pw = new PrintWriter(write);
            e.printStackTrace(pw);
            this.setTrace(write.toString());
        }
        return this.setStatus(Status.ERROR).setStatusMessage(e.getMessage()).setException(e.getClass().getName());
    }

    public static boolean isTraceEnable() {
        return traceEnable;
    }

    public static void setTraceEnable(boolean traceEnable) {
        Ack.traceEnable = traceEnable;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Ack [");
        if (this.cmdSn != null) {
            builder.append("cmdSn=");
            builder.append(this.cmdSn);
            builder.append(", ");
        }
        builder.append("deviceId=");
        builder.append(this.deviceId);
        builder.append(", ");
        if (this.deviceMac != null) {
            builder.append("deviceMac=");
            builder.append(this.deviceMac);
            builder.append(", ");
        }
        if (this.item != null) {
            builder.append("item=");
            builder.append(this.item);
            builder.append(", ");
        }
        if (this.value != null) {
            builder.append("value=");
            builder.append(this.value);
            builder.append(", ");
        }
        if (this.status != null) {
            builder.append("status=");
            builder.append((Object)this.status);
            builder.append(", ");
        }
        if (this.statusMessage != null) {
            builder.append("statusMessage=");
            builder.append(this.statusMessage);
            builder.append(", ");
        }
        if (this.exception != null) {
            builder.append("exception=");
            builder.append(this.exception);
        }
        builder.append("]");
        return builder.toString();
    }

    public static enum Status {
        OK,
        UNSUPPORTED,
        ERROR,
        TIMEOUT,
        REJECTED,
        ACCEPTED,
        PROGRESS,
        CANCELED;

    }
}

