/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gu.dtalk.Base64Option;
import gu.dtalk.BaseOption;
import gu.dtalk.BoolOption;
import gu.dtalk.CheckOption;
import gu.dtalk.CmdItem;
import gu.dtalk.DateOption;
import gu.dtalk.FloatOption;
import gu.dtalk.IPv4Option;
import gu.dtalk.ImageOption;
import gu.dtalk.IntOption;
import gu.dtalk.ItemType;
import gu.dtalk.MACOption;
import gu.dtalk.MenuItem;
import gu.dtalk.OptionType;
import gu.dtalk.PasswordOption;
import gu.dtalk.StringOption;
import gu.dtalk.SwitchOption;
import gu.dtalk.UrlOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseItem {
    private String name;
    private String uiName;
    @JSONField(serialize=false, deserialize=false)
    private BaseItem parent;
    private String path = null;
    private boolean disable = false;
    private boolean hide = false;
    @JSONField(deserialize=false)
    private String description = "";
    protected final LinkedHashMap<String, BaseItem> items = new LinkedHashMap();
    private static final Function<BaseItem, String> PATH_FUN = new Function<BaseItem, String>(){

        public String apply(BaseItem input) {
            return input.getPath();
        }
    };

    public String getName() {
        return this.name;
    }

    public BaseItem setName(String name) {
        Preconditions.checkArgument(((name = ((String)Preconditions.checkNotNull((Object)name, (Object)"name is null")).trim()).isEmpty() || name.matches("^[a-zA-Z]\\w+$") ? 1 : 0) != 0, (String)"invalid option name '%s',allow character:[a-zA-Z0-9_],not space char allowed,start with alphabet", (Object)name);
        this.name = name;
        return this;
    }

    public BaseItem getParent() {
        return this.parent;
    }

    private void checkCycleRef() {
        BaseItem node = this;
        while (node.parent != null) {
            Preconditions.checkState((node.parent != this ? 1 : 0) != 0, (Object)"CYCLE REFERENCE");
            node = node.parent;
        }
    }

    BaseItem setParent(BaseItem parent) {
        Preconditions.checkArgument((parent == null || parent.isContainer() ? 1 : 0) != 0, (Object)"INVALID parent");
        Preconditions.checkArgument((parent == null || !parent.getChilds().contains(this) ? 1 : 0) != 0, (String)"DUPLICATE element in parent [%s]", (Object)this.getName());
        this.parent = parent;
        this.checkCycleRef();
        this.refreshPath();
        return this;
    }

    public abstract boolean isContainer();

    public abstract ItemType getCatalog();

    private String createPath(boolean indexInstead) {
        ArrayList<String> list = new ArrayList<String>();
        BaseItem item = this;
        while (item.parent != null) {
            if (indexInstead) {
                list.add(Integer.toString(this.parent.getChilds().indexOf(item)));
            } else {
                list.add(item.getName());
            }
            item = item.parent;
        }
        return "/" + Joiner.on((char)'/').join((Iterable)Lists.reverse(list));
    }

    private void refreshPath() {
        this.path = this.createPath(false);
        for (BaseItem child : this.items.values()) {
            child.refreshPath();
        }
    }

    private String normalizePath(String path) {
        if ((path = ((String)MoreObjects.firstNonNull((Object)path, (Object)"")).trim()).length() > 1) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    public String getPath() {
        if (this.path == null) {
            this.refreshPath();
        }
        return this.path;
    }

    public BaseItem setPath(String path) {
        this.path = this.normalizePath(path);
        return this;
    }

    public boolean isDisable() {
        return this.disable;
    }

    public BaseItem setDisable(boolean disable) {
        this.disable = disable;
        return this;
    }

    public boolean isHide() {
        return this.hide;
    }

    public BaseItem setHide(boolean hide) {
        this.hide = hide;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public BaseItem setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getUiName() {
        return Strings.isNullOrEmpty((String)this.uiName) ? this.name : this.uiName;
    }

    public BaseItem setUiName(String uiName) {
        this.uiName = uiName;
        return this;
    }

    public String json() {
        return JSON.toJSONString((Object)this);
    }

    public String toString() {
        return this.json();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseItem)) {
            return false;
        }
        BaseItem other = (BaseItem)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public BaseItem getChildByPath(String path) {
        String relpath = path = ((String)MoreObjects.firstNonNull((Object)path, (Object)"")).trim();
        if (path.startsWith("/")) {
            if (path.startsWith(this.getPath())) {
                relpath = path.substring(this.getPath().length());
            } else {
                String inxpath = this.createPath(true);
                if (path.startsWith(inxpath)) {
                    relpath = path.substring(inxpath.length());
                } else {
                    return null;
                }
            }
        }
        if (relpath.isEmpty()) {
            return null;
        }
        if (relpath.startsWith("/")) {
            relpath = relpath.substring(1);
        }
        if (relpath.endsWith("/")) {
            relpath = relpath.substring(0, relpath.length() - 1);
        }
        String[] nodes = relpath.split("/");
        BaseItem child = this;
        for (String node : nodes) {
            if ((child = child.getChild(node)) != null) continue;
            return null;
        }
        return child;
    }

    public BaseItem find(String path) {
        BaseItem child = this.getChildByPath(path);
        if (child != null) {
            return child;
        }
        BaseItem root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root.getPath().equals(path) ? this : root.getChildByPath(path);
    }

    public BaseItem findChecked(String path) {
        return (BaseItem)Preconditions.checkNotNull((Object)this.find(path), (String)"NOT FOUND ITEM [%s]", (Object)path);
    }

    public MenuItem findMenu(String path) {
        BaseItem item = this.find(path);
        if (null == item) {
            return null;
        }
        Preconditions.checkArgument((boolean)(item instanceof MenuItem), (String)"FOUND %s item,MISMATCH %s", (Object)((Object)item.getCatalog()), (Object)((Object)ItemType.MENU));
        return (MenuItem)item;
    }

    public MenuItem findMenuChecked(String path) {
        return (MenuItem)Preconditions.checkNotNull((Object)this.findMenu(path), (String)"NOT FOUND MENU [%s]", (Object)path);
    }

    public CmdItem findCmd(String path) {
        BaseItem item = this.find(path);
        if (null == item) {
            return null;
        }
        Preconditions.checkArgument((boolean)(item instanceof CmdItem), (String)"FOUND %s item,MISMATCH %s", (Object)((Object)item.getCatalog()), (Object)((Object)ItemType.CMD));
        return (CmdItem)item;
    }

    public CmdItem findCmdChecked(String path) {
        return (CmdItem)Preconditions.checkNotNull((Object)this.findCmd(path), (String)"NOT FOUND CMD [%s]", (Object)path);
    }

    public <T> BaseOption<T> findOption(String path) {
        BaseItem item = this.find(path);
        if (null == item) {
            return null;
        }
        Preconditions.checkArgument((boolean)(item instanceof BaseOption), (String)"FOUND %s item with path [%s],MISMATCH catalog %s", (Object)((Object)item.getCatalog()), (Object)path, (Object)((Object)ItemType.OPTION));
        return (BaseOption)item;
    }

    public <T> BaseOption<T> findOptionChecked(String path) {
        BaseOption<T> opt = this.findOption(path);
        return (BaseOption)Preconditions.checkNotNull(opt, (String)"NOT FOUND OPTION [%s]", (Object)path);
    }

    public <T> T findOption(String path, OptionType type) {
        BaseOption<T> item = this.findOption(path);
        if (null == item) {
            return null;
        }
        Preconditions.checkArgument((boolean)type.optionClass().isInstance(item), (String)"FOUND %s item with [%s],MISMATCH type %s", (Object)((Object)item.getType()), (Object)path, (Object)((Object)type));
        return (T)type.optionClass().cast(item);
    }

    public Base64Option findBase64Option(String path) {
        return (Base64Option)this.findOption(path, OptionType.BASE64);
    }

    public BoolOption findBoolOption(String path) {
        return (BoolOption)this.findOption(path, OptionType.BOOL);
    }

    public IPv4Option findIPv4Option(String path) {
        return (IPv4Option)this.findOption(path, OptionType.IP);
    }

    public MACOption findMACOption(String path) {
        return (MACOption)this.findOption(path, OptionType.MAC);
    }

    public IntOption findIntOption(String path) {
        return (IntOption)this.findOption(path, OptionType.INTEGER);
    }

    public FloatOption findFloatOption(String path) {
        return (FloatOption)this.findOption(path, OptionType.FLOAT);
    }

    public DateOption findDateOption(String path) {
        return (DateOption)this.findOption(path, OptionType.DATE);
    }

    public StringOption findStringOption(String path) {
        return (StringOption)this.findOption(path, OptionType.STRING);
    }

    public PasswordOption findPasswordOption(String path) {
        return (PasswordOption)this.findOption(path, OptionType.PASSWORD);
    }

    public UrlOption findUrlOption(String path) {
        return (UrlOption)this.findOption(path, OptionType.URL);
    }

    public ImageOption findImageOption(String path) {
        return (ImageOption)this.findOption(path, OptionType.IMAGE);
    }

    public <T> CheckOption<T> findCheckOption(String path) {
        return (CheckOption)this.findOption(path, OptionType.MULTICHECK);
    }

    public <T> SwitchOption<T> findSwitchOption(String path) {
        return (SwitchOption)this.findOption(path, OptionType.SWITCH);
    }

    public List<BaseItem> getChilds() {
        return Lists.newArrayList(this.items.values());
    }

    public BaseItem setChilds(List<BaseItem> childs) {
        this.items.clear();
        return this.addChilds(childs);
    }

    public BaseItem addChilds(BaseItem ... childs) {
        return this.addChilds(Arrays.asList(childs));
    }

    public BaseItem addChilds(Collection<BaseItem> childs) {
        childs = (Collection)MoreObjects.firstNonNull(childs, Collections.emptyList());
        for (BaseItem child : childs) {
            if (this.items.containsKey(child.getName())) continue;
            child.setParent(this);
            this.items.put(child.getName(), child);
        }
        return this;
    }

    public BaseItem addChilds(int index, BaseItem child) {
        Preconditions.checkArgument((child != null ? 1 : 0) != 0, (Object)"child is null");
        if (this.items.size() == 0) {
            return this.addChilds(child);
        }
        if (!this.items.containsKey(child.getName())) {
            if (index >= this.items.size() || index < 0) {
                index = this.items.size() - 1;
            }
            int i = 0;
            ArrayList<Map.Entry<String, BaseItem>> rest = new ArrayList<Map.Entry<String, BaseItem>>();
            for (Map.Entry<String, BaseItem> entry : this.items.entrySet()) {
                if (i++ < index) continue;
                rest.add(entry);
            }
            child.setParent(this);
            this.items.put(child.getName(), child);
            for (Map.Entry<String, BaseItem> entry : rest) {
                this.items.remove(entry.getKey());
                this.items.put(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public int childCount() {
        return this.items.size();
    }

    public Map<String, String> childNames() {
        return Maps.newLinkedHashMap((Map)Maps.transformValues(this.items, PATH_FUN));
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public BaseItem getChild(String name) {
        BaseItem item = this.items.get(name);
        if (null == item) {
            try {
                return this.getChilds().get(Integer.valueOf(name));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return item;
    }

    public void updateChild(BaseItem item) {
        if (this.items.containsKey(item.getName())) {
            this.items.remove(item.getName());
            this.addChilds(item);
        }
    }
}

