/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gu.dtalk.BaseItem;
import gu.dtalk.CmdItem;
import gu.dtalk.ItemType;
import gu.dtalk.OptionType;
import gu.dtalk.event.ValueChangeEvent;
import gu.dtalk.event.ValueListener;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Observable;

public abstract class BaseOption<T>
extends BaseItem {
    private T optionValue;
    private T defaultValue;
    private boolean required;
    private boolean readOnly;
    private boolean needReset;
    private boolean needRefresh;
    protected final Type type;
    protected final Observable observable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };
    @JSONField(serialize=false, deserialize=false)
    private Predicate<T> valueValidator = Predicates.alwaysTrue();
    private LinkedHashSet<T> available = Sets.newLinkedHashSet();

    public BaseOption(Type type) {
        this.type = (Type)Preconditions.checkNotNull((Object)type);
    }

    public Type javaType() {
        return this.type;
    }

    public abstract OptionType getType();

    BaseOption<T> setType(OptionType type) {
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public BaseOption<T> setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public boolean isNeedReset() {
        return this.needReset;
    }

    public BaseOption<T> setNeedReset(boolean needReset) {
        this.needReset = needReset;
        return this;
    }

    public boolean isNeedRefresh() {
        return this.needRefresh;
    }

    public void setNeedRefresh(boolean needRefresh) {
        this.needRefresh = needRefresh;
    }

    public String getRegex() {
        return this.getType().regex;
    }

    public BaseOption<T> setRegex(String regex) {
        return this;
    }

    @Override
    public final boolean isContainer() {
        return false;
    }

    @Override
    public final ItemType getCatalog() {
        return ItemType.OPTION;
    }

    @Override
    public final BaseItem addChilds(Collection<BaseItem> childs) {
        return this;
    }

    public boolean validate(Object value) {
        try {
            return this.valueValidator.apply(value);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public final T getValue() {
        return this.optionValue;
    }

    public BaseOption<T> setValue(T value) {
        if (!Objects.equal(value, this.optionValue)) {
            this.optionValue = value;
            this.observable.notifyObservers(new ValueChangeEvent<BaseOption>(this));
        }
        return this;
    }

    public void updateFrom(T value) {
        Preconditions.checkState((!this.isReadOnly() ? 1 : 0) != 0, (Object)"READONLY VALUE");
        Preconditions.checkArgument((boolean)this.valueValidator.apply(value), (Object)"INVALID VALUE");
        this.setValue(value);
    }

    public void updateFrom(BaseOption<T> req) {
        if (req != null) {
            this.updateFrom(req.getValue());
        }
    }

    public final T getDefaultValue() {
        return this.defaultValue;
    }

    public BaseOption<T> setDefaultValue(T defaultValue) {
        Preconditions.checkArgument((null == defaultValue || this.validate(defaultValue) ? 1 : 0) != 0, (Object)"INVALID DEFAULT VALUE");
        this.defaultValue = defaultValue;
        return this;
    }

    public T fetch() {
        if (this.getValue() == null) {
            return this.getDefaultValue();
        }
        return this.getValue();
    }

    public synchronized BaseOption<T> setValidator(Predicate<T> validator) {
        if (validator != null) {
            this.valueValidator = validator;
        }
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public BaseOption<T> setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public String contentOfValue() {
        return this.optionValue == null ? "" : this.optionValue.toString();
    }

    public BaseOption<T> asValue(String input) {
        return this.setValue(this.getType().trans().apply((Object)input));
    }

    public BaseOption<T> asDefaultValue(String input) {
        return this.setDefaultValue(this.getType().trans().apply((Object)input));
    }

    public BaseOption<T> compile() {
        Preconditions.checkArgument((null == this.getValue() || this.validate(this.getValue()) ? 1 : 0) != 0, (String)"CHECK:invalid value of %s", (Object)this.getType().name());
        Preconditions.checkArgument((null == this.getDefaultValue() || this.validate(this.getDefaultValue()) ? 1 : 0) != 0, (String)"CHECK:invalid defaultValue of %s", (Object)this.getType().name());
        return this;
    }

    @SafeVarargs
    public final BaseOption<T> addListener(ValueListener<T> ... listeners) {
        for (ValueListener listener : (ValueListener[])MoreObjects.firstNonNull(listeners, (Object)new ValueListener[0])) {
            if (listener == null) continue;
            this.observable.addObserver(listener);
        }
        return this;
    }

    @SafeVarargs
    public final BaseOption<T> deleteListener(ValueListener<T> ... listeners) {
        for (ValueListener listener : (ValueListener[])MoreObjects.firstNonNull(listeners, (Object)new ValueListener[0])) {
            if (listener == null) continue;
            this.observable.deleteObserver(listener);
        }
        return this;
    }

    @Override
    BaseOption<T> setParent(BaseItem parent) {
        super.setParent(parent);
        if (parent instanceof CmdItem) {
            this.setDisable(false);
            this.setReadOnly(false);
        }
        return this;
    }

    public List<T> getAvailable() {
        return Lists.newArrayList(this.available);
    }

    public BaseOption<T> setAvailable(List<T> available) {
        this.available.clear();
        this.available.addAll((Collection)MoreObjects.firstNonNull(available, Collections.emptyList()));
        return this;
    }

    public BaseOption<T> addAvailable(T ... values) {
        if (values != null) {
            this.available.addAll(Collections2.filter(Arrays.asList(values), (Predicate)Predicates.notNull()));
        }
        return this;
    }

    public BaseOption<T> removeAvailable(T ... values) {
        if (values != null) {
            this.available.removeAll(Collections2.filter(Arrays.asList(values), (Predicate)Predicates.notNull()));
        }
        return this;
    }

    public void clearAvailable() {
        this.available.clear();
    }
}

