/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class Ack<T> {
    private long cmdSn;
    private int deviceId;
    private T value;
    private Status status;
    private String errorMessage;

    public String message() {
        Preconditions.checkArgument(null != this.status, "status field is null");
        StringBuffer buffer = new StringBuffer(String.format("device%d@%d:%s", this.deviceId, this.cmdSn, this.status.name()));
        switch (this.status) {
            case ERROR: {
                if (Strings.isNullOrEmpty(this.errorMessage)) break;
                buffer.append(":").append(this.errorMessage);
                break;
            }
        }
        return buffer.toString();
    }

    public long getCmdSn() {
        return this.cmdSn;
    }

    public Ack<T> setCmdSn(long cmdSn) {
        this.cmdSn = cmdSn;
        return this;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public Ack<T> setDeviceId(int deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public T getValue() {
        return this.value;
    }

    public Ack<T> setValue(T value) {
        this.value = value;
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    public Ack<T> setStatus(Status status) {
        this.status = status;
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Ack<T> setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Ack [cmdSn=");
        builder.append(this.cmdSn);
        builder.append(", deviceId=");
        builder.append(this.deviceId);
        builder.append(", value=");
        builder.append(this.value);
        builder.append(", status=");
        builder.append((Object)this.status);
        builder.append(", errorMessage=");
        builder.append(this.errorMessage);
        builder.append("]");
        return builder.toString();
    }

    public static enum Status {
        OK,
        UNSUPPORTED,
        ERROR,
        TIMEOUT;

    }
}

