/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gu.dtalk.Base64Option;
import gu.dtalk.BaseOption;
import gu.dtalk.BoolOption;
import gu.dtalk.CheckOption;
import gu.dtalk.CmdItem;
import gu.dtalk.DateOption;
import gu.dtalk.FloatOption;
import gu.dtalk.IPv4Option;
import gu.dtalk.ImageOption;
import gu.dtalk.IntOption;
import gu.dtalk.ItemType;
import gu.dtalk.MACOption;
import gu.dtalk.MenuItem;
import gu.dtalk.PasswordOption;
import gu.dtalk.StringOption;
import gu.dtalk.SwitchOption;
import gu.dtalk.UrlOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseItem {
    private String name;
    private String uiName;
    @JSONField(serialize=false, deserialize=false)
    private BaseItem parent;
    private String path = null;
    private boolean disable = false;
    @JSONField(deserialize=false)
    private String description = "";
    protected final LinkedHashMap<String, BaseItem> items = new LinkedHashMap();
    private static final Function<BaseItem, String> PATH_FUN = new Function<BaseItem, String>(){

        @Override
        public String apply(BaseItem input) {
            return input.getPath();
        }
    };

    public String getName() {
        return this.name;
    }

    public BaseItem setName(String name) {
        Preconditions.checkArgument((name = Preconditions.checkNotNull(name, "name is null").trim()).isEmpty() || name.matches("^[a-zA-Z]\\w+$"), "invalid option name '%s',allow character:[a-zA-Z0-9_],not space char allowed,start with alphabet", (Object)name);
        this.name = name;
        return this;
    }

    public BaseItem getParent() {
        return this.parent;
    }

    private void checkCycleRef() {
        BaseItem node = this;
        while (node.parent != null) {
            Preconditions.checkState(node.parent != this, "CYCLE REFERENCE");
            node = node.parent;
        }
    }

    BaseItem setParent(BaseItem parent) {
        Preconditions.checkArgument(parent == null || parent.isContainer(), "INVALID parent");
        Preconditions.checkArgument(parent == null || !parent.getChilds().contains(this), "DUPLICATE element in parent [%s]", (Object)this.getName());
        this.parent = parent;
        this.checkCycleRef();
        this.refreshPath();
        return this;
    }

    public abstract boolean isContainer();

    public abstract ItemType getCatalog();

    private String createPath(boolean indexInstead) {
        ArrayList<String> list = new ArrayList<String>();
        BaseItem item = this;
        while (item.parent != null) {
            if (indexInstead) {
                list.add(Integer.toString(this.parent.getChilds().indexOf(item)));
            } else {
                list.add(item.getName());
            }
            item = item.parent;
        }
        return "/" + Joiner.on('/').join(Lists.reverse(list));
    }

    private void refreshPath() {
        this.path = this.createPath(false);
        for (BaseItem child : this.items.values()) {
            child.refreshPath();
        }
    }

    private String normalizePath(String path) {
        if ((path = MoreObjects.firstNonNull(path, "").trim()).length() > 1) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    public String getPath() {
        if (this.path == null) {
            this.refreshPath();
        }
        return this.path;
    }

    public BaseItem setPath(String path) {
        this.path = this.normalizePath(path);
        return this;
    }

    public boolean isDisable() {
        return this.disable;
    }

    public BaseItem setDisable(boolean disable) {
        this.disable = disable;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public BaseItem setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getUiName() {
        return Strings.isNullOrEmpty(this.uiName) ? this.name : this.uiName;
    }

    public BaseItem setUiName(String uiName) {
        this.uiName = uiName;
        return this;
    }

    public String json() {
        return JSON.toJSONString(this);
    }

    public String toString() {
        return this.json();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseItem)) {
            return false;
        }
        BaseItem other = (BaseItem)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public BaseItem getChildByPath(String path) {
        String relpath = path = MoreObjects.firstNonNull(path, "").trim();
        if (path.startsWith("/")) {
            if (path.startsWith(this.getPath())) {
                relpath = path.substring(this.getPath().length());
            } else {
                String inxpath = this.createPath(true);
                if (path.startsWith(inxpath)) {
                    relpath = path.substring(inxpath.length());
                } else {
                    return null;
                }
            }
        }
        if (relpath.isEmpty()) {
            return null;
        }
        if (relpath.startsWith("/")) {
            relpath = relpath.substring(1);
        }
        if (relpath.endsWith("/")) {
            relpath = relpath.substring(0, relpath.length() - 1);
        }
        String[] nodes = relpath.split("/");
        BaseItem child = this;
        for (String node : nodes) {
            if ((child = child.getChild(node)) != null) continue;
            return null;
        }
        return child;
    }

    public BaseItem find(String path) {
        BaseItem child = this.getChildByPath(path);
        if (child != null) {
            return child;
        }
        BaseItem root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root.getPath().equals(path) ? this : root.getChildByPath(path);
    }

    public BaseItem findChecked(String path) {
        return Preconditions.checkNotNull(this.find(path), "NOT FOUND ITEM [%s]", (Object)path);
    }

    public MenuItem findMenu(String path) {
        BaseItem item = this.find(path);
        return item instanceof MenuItem ? (MenuItem)item : null;
    }

    public MenuItem findMenuChecked(String path) {
        return Preconditions.checkNotNull(this.findMenu(path), "NOT FOUND MENU [%s]", (Object)path);
    }

    public CmdItem findCmd(String path) {
        BaseItem item = this.find(path);
        return item instanceof CmdItem ? (CmdItem)item : null;
    }

    public CmdItem findCmdChecked(String path) {
        return Preconditions.checkNotNull(this.findCmd(path), "NOT FOUND CMD [%s]", (Object)path);
    }

    public <T> BaseOption<T> findOption(String path) {
        BaseItem item = this.find(path);
        return item instanceof BaseOption ? (BaseOption)item : null;
    }

    public <T> BaseOption<T> findOptionChecked(String path) {
        BaseOption<T> opt = this.findOption(path);
        return Preconditions.checkNotNull(opt, "NOT FOUND OPTION [%s]", (Object)path);
    }

    public Base64Option findBase64Option(String path) {
        BaseItem item = this.find(path);
        return item instanceof Base64Option ? (Base64Option)item : null;
    }

    public BoolOption findBoolOption(String path) {
        BaseItem item = this.find(path);
        return item instanceof BoolOption ? (BoolOption)item : null;
    }

    public IPv4Option findIPv4Option(String path) {
        BaseItem item = this.find(path);
        return item instanceof IPv4Option ? (IPv4Option)item : null;
    }

    public MACOption findMACOption(String path) {
        BaseItem item = this.find(path);
        return item instanceof MACOption ? (MACOption)item : null;
    }

    public IntOption findIntOption(String path) {
        BaseItem item = this.find(path);
        return item instanceof IntOption ? (IntOption)item : null;
    }

    public FloatOption findFloatOption(String path) {
        BaseItem item = this.find(path);
        return item instanceof FloatOption ? (FloatOption)item : null;
    }

    public DateOption findDateOption(String path) {
        BaseItem item = this.find(path);
        return item instanceof DateOption ? (DateOption)item : null;
    }

    public StringOption findStringOption(String path) {
        BaseItem item = this.find(path);
        return item instanceof StringOption ? (StringOption)item : null;
    }

    public PasswordOption findPasswordOption(String path) {
        BaseItem item = this.find(path);
        return item instanceof PasswordOption ? (PasswordOption)item : null;
    }

    public UrlOption findUrlOption(String path) {
        BaseItem item = this.find(path);
        return item instanceof UrlOption ? (UrlOption)item : null;
    }

    public ImageOption findImageOption(String path) {
        BaseItem item = this.find(path);
        return item instanceof ImageOption ? (ImageOption)item : null;
    }

    public <T> CheckOption<T> findCheckOption(String path) {
        BaseItem item = this.find(path);
        return item instanceof CheckOption ? (CheckOption)item : null;
    }

    public <T> SwitchOption<T> findSwitchOption(String path) {
        BaseItem item = this.find(path);
        return item instanceof SwitchOption ? (SwitchOption)item : null;
    }

    public List<BaseItem> getChilds() {
        return Lists.newArrayList(this.items.values());
    }

    public BaseItem setChilds(List<BaseItem> childs) {
        this.items.clear();
        return this.addChilds(childs);
    }

    public BaseItem addChilds(BaseItem ... childs) {
        return this.addChilds(Arrays.asList(childs));
    }

    public BaseItem addChilds(Collection<BaseItem> childs) {
        childs = MoreObjects.firstNonNull(childs, Collections.emptyList());
        for (BaseItem child : childs) {
            if (this.items.containsKey(child.getName())) continue;
            child.setParent(this);
            this.items.put(child.getName(), child);
        }
        return this;
    }

    public int childCount() {
        return this.items.size();
    }

    public Map<String, String> childNames() {
        return Maps.newLinkedHashMap(Maps.transformValues(this.items, PATH_FUN));
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public BaseItem getChild(String name) {
        BaseItem item = this.items.get(name);
        if (null == item) {
            try {
                return this.getChilds().get(Integer.valueOf(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return item;
    }

    public void updateChild(BaseItem item) {
        if (this.items.containsKey(item.getName())) {
            this.items.remove(item.getName());
            this.addChilds(item);
        }
    }
}

