/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gu.dtalk.BaseItem;
import gu.dtalk.BaseOption;
import gu.dtalk.ItemType;
import gu.dtalk.TaskAdapter;
import gu.dtalk.exception.CmdExecutionException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CmdItem
extends BaseItem {
    private static final Function<BaseItem, BaseOption<Object>> TO_OPTION = new Function<BaseItem, BaseOption<Object>>(){

        @Override
        public BaseOption<Object> apply(BaseItem input) {
            return (BaseOption)input;
        }
    };
    private static final Function<BaseOption<?>, BaseItem> TO_ITEM = new Function<BaseOption<?>, BaseItem>(){

        @Override
        public BaseItem apply(BaseOption<?> input) {
            return input;
        }
    };
    private static final Function<BaseItem, Object> TO_VALUE = new Function<BaseItem, Object>(){

        @Override
        public Object apply(BaseItem input) {
            return ((BaseOption)input).fetch();
        }
    };
    @JSONField(serialize=false, deserialize=false)
    private ICmdAdapter cmdAdapter;
    private String taskQueue;

    @Override
    public final boolean isContainer() {
        return true;
    }

    @Override
    public final ItemType getCatalog() {
        return ItemType.CMD;
    }

    @JSONField(serialize=false, deserialize=false)
    public List<BaseOption<Object>> getParameters() {
        return Lists.transform(this.getChilds(), TO_OPTION);
    }

    @JSONField(serialize=false, deserialize=false)
    public void setParameters(List<BaseOption<?>> parameters) {
        this.items.clear();
        this.addParameters(parameters);
    }

    public CmdItem addParameters(BaseOption<?> ... parameter) {
        return this.addParameters(Arrays.asList(parameter));
    }

    public CmdItem addParameters(Collection<BaseOption<?>> parameters) {
        this.addChilds(Collections2.transform(parameters, TO_ITEM));
        return this;
    }

    public ICmdAdapter getCmdAdapter() {
        return this.cmdAdapter;
    }

    public CmdItem setCmdAdapter(ICmdAdapter cmdAdapter) {
        this.cmdAdapter = cmdAdapter;
        return this;
    }

    public static final <T> T cast(Object value, Type type) {
        return TypeUtils.cast(value, type, ParserConfig.getGlobalInstance());
    }

    private CmdItem updateParameter(Map<String, ?> parameters) {
        parameters = MoreObjects.firstNonNull(parameters, Collections.emptyMap());
        for (BaseOption<Object> param : this.getParameters()) {
            Object value = CmdItem.cast(parameters.get(param.getName()), param.javaType());
            param.updateFrom(value);
        }
        return this;
    }

    private Map<String, Object> checkRequired(Map<String, Object> input) {
        for (BaseOption<Object> param : this.getParameters()) {
            Preconditions.checkArgument(!param.isRequired() || input.containsKey(param.getName()), "MISS REQUIRED PARAM %s", (Object)param.getName());
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Object runCmd() throws CmdExecutionException {
        LinkedHashMap linkedHashMap = this.items;
        synchronized (linkedHashMap) {
            Object object;
            if (this.cmdAdapter == null) return null;
            try {
                Map<String, Object> objParams = Maps.transformValues(this.items, TO_VALUE);
                object = this.cmdAdapter.apply(this.checkRequired(objParams));
                this.reset();
            }
            catch (Throwable throwable) {
                this.reset();
                throw throwable;
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Object runCmd(Map<String, ?> parameters) throws CmdExecutionException {
        LinkedHashMap linkedHashMap = this.items;
        synchronized (linkedHashMap) {
            Object object;
            if (this.cmdAdapter == null) return null;
            this.updateParameter(parameters);
            try {
                Map<String, Object> objParams = Maps.transformValues(this.items, TO_VALUE);
                object = this.cmdAdapter.apply(this.checkRequired(objParams));
                this.reset();
            }
            catch (Throwable throwable) {
                this.reset();
                throw throwable;
            }
            return object;
        }
    }

    public <T> BaseOption<T> getParameter(String name) {
        return (BaseOption)this.getChild(name);
    }

    public CmdItem reset() {
        for (BaseOption<Object> item : this.getParameters()) {
            item.setValue(null);
        }
        return this;
    }

    public CmdItem asTaskAdapter(String queue) {
        if (this.cmdAdapter != null) {
            new TaskAdapter(queue).setCmdAdapter(this.cmdAdapter).register();
            this.taskQueue = queue;
        }
        return this;
    }

    public CmdItem asTaskAdapter(String queue, Class<? extends TaskAdapter> taskAdatperClass) {
        if (this.cmdAdapter != null) {
            try {
                Preconditions.checkNotNull(taskAdatperClass, "taskAdatperClass is null").getConstructor(String.class).newInstance(queue).setCmdAdapter(this.cmdAdapter).register();
                this.taskQueue = queue;
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public String getTaskQueue() {
        return this.taskQueue;
    }

    public void setTaskQueue(String taskQueue) {
        this.taskQueue = taskQueue;
    }

    public static interface ICmdAdapter {
        public Object apply(Map<String, Object> var1) throws CmdExecutionException;
    }
}

