/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import gu.dtalk.BaseItem;
import gu.dtalk.BaseOption;
import gu.dtalk.CmdItem;
import gu.dtalk.ItemType;
import gu.dtalk.OptionType;
import net.gdface.utils.FaceUtilits;

public class CommonUtils {
    public static String getAckChannel(String mac) {
        return mac + "_dtalk_ack";
    }

    public static String getAckChannel(byte[] mac) {
        return CommonUtils.getAckChannel(FaceUtilits.toHex(mac));
    }

    public static String getConnChannel(String mac) {
        return mac + "_dtalk_connect";
    }

    public static String getConnChannel(byte[] mac) {
        return CommonUtils.getConnChannel(FaceUtilits.toHex(mac));
    }

    private static boolean hasField(Object resp, String name) {
        return resp instanceof JSONObject && ((JSONObject)resp).containsKey(name);
    }

    public static boolean isAck(Object resp) {
        return resp instanceof JSONObject && CommonUtils.hasField((JSONObject)resp, "status");
    }

    public static boolean isItem(Object resp) {
        return CommonUtils.hasField(resp, "name") && CommonUtils.hasField(resp, "path") && CommonUtils.hasField(resp, "catalog");
    }

    public static CmdItem makeQuit() {
        CmdItem item = new CmdItem();
        item.setName("quit");
        return item;
    }

    public static CmdItem makeBack() {
        CmdItem item = new CmdItem();
        item.setName("back");
        return item;
    }

    public static boolean isBack(BaseItem item) {
        return item instanceof BaseItem && "back".equals(item.getName());
    }

    public static boolean isRoot(JSONObject item) {
        return item instanceof JSONObject && "/".equals(item.getString("path"));
    }

    public static boolean isRoot(BaseItem item) {
        return item instanceof BaseItem && null == item.getParent();
    }

    public static boolean isQuit(BaseItem item) {
        return item instanceof BaseItem && "quit".equals(item.getName());
    }

    public static boolean isQuit(JSONObject item) {
        return item instanceof JSONObject && "quit".equals(item.getString("name"));
    }

    public static boolean isQuit(JSONObject item, BaseItem start) {
        return CommonUtils.isQuit(CommonUtils.normalize(item, start));
    }

    public static boolean isQuit(Object item) {
        return CommonUtils.isQuit((BaseItem)item) || CommonUtils.isQuit((JSONObject)item);
    }

    public static boolean isImage(JSONObject item) {
        return item == null ? false : OptionType.IMAGE.name().equals(item.getString("type"));
    }

    public static JSONObject normalize(JSONObject jsonObject, BaseItem start) {
        if (null != jsonObject && null != start) {
            BaseItem node;
            String name = jsonObject.getString("name");
            String path = jsonObject.getString("path");
            Preconditions.checkArgument(name != null || path != null, "NOT DEFINED path or name");
            if (path != null) {
                node = start.findChecked(path);
            } else if (name != null) {
                node = start.findChecked(name);
            } else {
                throw new IllegalArgumentException("NOT DEFINED path or name");
            }
            if (jsonObject.containsKey("catalog")) {
                Preconditions.checkArgument(node.getCatalog().equals((Object)jsonObject.getObject("catalog", ItemType.class)), "MISMATCH CATALOG %s", (Object)node.getPath());
            } else {
                jsonObject.fluentPut("catalog", (Object)node.getCatalog());
            }
            if (node instanceof BaseOption) {
                BaseOption opt = (BaseOption)node;
                if (jsonObject.containsKey("type")) {
                    Preconditions.checkArgument(opt.getType().equals((Object)jsonObject.getObject("type", OptionType.class)), "MISMATCH TYPE %s", (Object)node.getPath());
                } else {
                    jsonObject.fluentPut("type", (Object)opt.getType());
                }
            }
            if (name == null) {
                jsonObject.fluentPut("name", node.getName());
            }
            for (Object child : MoreObjects.firstNonNull(jsonObject.getJSONArray("childs"), new JSONArray())) {
                Preconditions.checkArgument(child instanceof JSONObject, "INVALID JSON FORMAT FOR CHILD OF %s", (Object)node.getPath());
                CommonUtils.normalize((JSONObject)child, node);
            }
        }
        return jsonObject;
    }
}

