/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import gu.dtalk.BaseItem;
import gu.dtalk.BaseOption;
import gu.dtalk.OptionType;
import gu.dtalk.event.ValueListener;
import java.lang.reflect.Modifier;

public class OptionBuilder<T, O extends BaseOption<T>> {
    private final O option;

    public OptionBuilder(O item) {
        this.option = item;
    }

    public OptionBuilder<T, O> name(String name) {
        ((BaseItem)this.option).setName(name);
        return this;
    }

    public OptionBuilder<T, O> disable(boolean disable) {
        ((BaseItem)this.option).setDisable(disable);
        return this;
    }

    public OptionBuilder<T, O> readonly(boolean readOnly) {
        ((BaseOption)this.option).setReadOnly(readOnly);
        return this;
    }

    public OptionBuilder<T, O> required(boolean required) {
        ((BaseOption)this.option).setRequired(required);
        return this;
    }

    public OptionBuilder<T, O> description(String description) {
        ((BaseItem)this.option).setDescription(description);
        return this;
    }

    public OptionBuilder<T, O> uiName(String uiName) {
        ((BaseItem)this.option).setUiName(uiName);
        return this;
    }

    public OptionBuilder<T, O> value(T value) {
        ((BaseOption)this.option).setValue(value);
        return this;
    }

    public OptionBuilder<T, O> defaultValue(T value) {
        ((BaseOption)this.option).setDefaultValue(value);
        return this;
    }

    public OptionBuilder<T, O> asValue(String value) {
        ((BaseOption)this.option).asValue(value);
        return this;
    }

    public OptionBuilder<T, O> asDefaultValue(String value) {
        ((BaseOption)this.option).asDefaultValue(value);
        return this;
    }

    public OptionBuilder<T, O> validator(Predicate<T> validator) {
        ((BaseOption)this.option).setValidator(validator);
        return this;
    }

    @SafeVarargs
    public final OptionBuilder<T, O> addListener(ValueListener<T> ... listeners) {
        ((BaseOption)this.option).addListener(listeners);
        return this;
    }

    public O instance() {
        ((BaseOption)this.option).compile();
        return this.option;
    }

    public static <T, O extends BaseOption<T>> OptionBuilder<T, O> builder(O instance) {
        return new OptionBuilder<T, O>(Preconditions.checkNotNull(instance, "instance is null"));
    }

    public static <T, O extends BaseOption<T>> OptionBuilder<T, O> builder(Class<O> type) {
        Preconditions.checkArgument(!Modifier.isAbstract(type.getModifiers()), "%s is a abstract class", (Object)type.getName());
        try {
            return new OptionBuilder<T, BaseOption>((BaseOption)type.newInstance());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public static <T, O extends BaseOption<T>> OptionBuilder<T, O> builder(OptionType optionType) {
        Class<? extends BaseOption> type = Preconditions.checkNotNull(optionType, (Object)"optionType is null").optClass;
        try {
            return new OptionBuilder(type.newInstance().setType(optionType));
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
}

