/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gu.dtalk.Ack;
import gu.dtalk.CmdItem;
import gu.dtalk.exception.CmdExecutionException;
import gu.dtalk.exception.DtalkException;
import gu.dtalk.exception.UnsupportCmdException;
import gu.simplemq.Channel;
import gu.simplemq.IMessageAdapter;
import gu.simplemq.exceptions.SmqUnsubscribeException;
import gu.simplemq.redis.RedisFactory;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TaskAdapter
implements IMessageAdapter<Map<String, Object>> {
    public static final String P_TASK_ACK = "taskAck";
    public static final String P_TASK_ID = "taskId";
    private final Channel<Map<String, Object>> channel;
    private CmdItem.ICmdAdapter cmdAdapter;
    protected static final ExecutorService publishExecutor = MoreExecutors.getExitingExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("task-ack-publish-%d").build()));

    public TaskAdapter(String queue) {
        this.channel = new Channel<Map<String, Object>>(queue, (IMessageAdapter)this){};
    }

    @Override
    public final void onSubscribe(Map<String, Object> parameter) throws SmqUnsubscribeException {
        String ackChannel;
        parameter = MoreObjects.firstNonNull(parameter, Collections.emptyMap());
        Object res = null;
        DtalkException err = null;
        try {
            if (this.cmdAdapter == null) {
                throw new UnsupportCmdException("UNSUPPORTED TASK");
            }
            res = this.cmdAdapter.apply(parameter);
        }
        catch (CmdExecutionException e) {
            err = e;
        }
        catch (UnsupportCmdException e) {
            err = e;
        }
        Object tack = parameter.get(P_TASK_ACK);
        Object tid = parameter.get(P_TASK_ID);
        if (tack instanceof String && !Strings.isNullOrEmpty(ackChannel = (String)tack)) {
            Object ack = this.makeAck(res, err, ackChannel, tid instanceof Number ? (Number)((Number)tid) : (Number)-1);
            this.publish(ackChannel, ack);
        }
    }

    protected <T, ACK> ACK makeAck(T res, Exception err, String ackChannel, Number taskid) {
        Ack ack = new Ack().setStatus(Ack.Status.OK).setValue(res).setCmdSn(taskid.longValue());
        if (err != null) {
            ack.setStatus(Ack.Status.ERROR).setErrorMessage(err.getMessage());
        }
        return (ACK)ack;
    }

    public String getQueue() {
        return this.channel.name;
    }

    public final TaskAdapter register() {
        RedisFactory.getConsumer().register(this.channel);
        return this;
    }

    public final TaskAdapter unregister() {
        RedisFactory.getConsumer().unregister(this.channel);
        return this;
    }

    public CmdItem.ICmdAdapter getCmdAdapter() {
        return this.cmdAdapter;
    }

    public TaskAdapter setCmdAdapter(CmdItem.ICmdAdapter cmdAdapter) {
        this.cmdAdapter = cmdAdapter;
        return this;
    }

    private <T> void publish(final String ackChannel, final T ack) {
        if (ack != null) {
            publishExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    Channel ch = new Channel(ackChannel, (Type)ack.getClass());
                    RedisFactory.getPublisher().publish(ch, ack);
                }
            });
        }
    }
}

