/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.client;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.net.HostAndPort;
import gu.dtalk.Ack;
import gu.dtalk.BaseItem;
import gu.dtalk.BaseOption;
import gu.dtalk.CmdItem;
import gu.dtalk.CommonUtils;
import gu.dtalk.ItemType;
import gu.dtalk.client.ConnectorAdapter;
import gu.dtalk.client.RenderEngine;
import gu.dtalk.client.TextMessageAdapter;
import gu.dtalk.redis.RedisConfigType;
import gu.simplemq.Channel;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.RedisFactory;
import gu.simplemq.redis.RedisPublisher;
import gu.simplemq.redis.RedisSubscriber;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import net.gdface.utils.FaceUtilits;
import net.gdface.utils.NetworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConsole {
    protected static final Logger logger = LoggerFactory.getLogger(BaseConsole.class);
    final RedisSubscriber subscriber;
    final RedisPublisher publisher;
    protected String reqChannel = null;
    protected final byte[] temminalMac;
    private final String ackchname;
    protected final String connchname;
    private final RenderEngine renderEngine = new RenderEngine();
    private final Channel<JSONObject> ackChannel;
    private boolean stackTrace = false;

    public BaseConsole(String devmac, RedisConfigType config) {
        JedisPoolLazy pool = JedisPoolLazy.getInstance(config.readRedisParam(), false);
        this.subscriber = RedisFactory.getSubscriber(pool);
        this.publisher = RedisFactory.getPublisher(pool);
        this.temminalMac = BaseConsole.getSelfMac(config);
        System.out.printf("TERMINAL MAC address: %s\n", NetworkUtil.formatMac(this.temminalMac, ":"));
        this.ackchname = CommonUtils.getAckChannel(this.temminalMac);
        ConnectorAdapter msgAdapter = new ConnectorAdapter().setOnValidPwd(new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                BaseConsole.this.reqChannel = input;
                BaseConsole.this.ackChannel.setAdapter(BaseConsole.this.renderEngine);
                return false;
            }
        });
        this.ackChannel = new Channel<JSONObject>(this.ackchname, JSONObject.class).setAdapter(msgAdapter);
        if (Strings.isNullOrEmpty(devmac)) {
            devmac = FaceUtilits.toHex(this.temminalMac);
            System.out.println("use local MAC for target DEVICE");
        }
        System.out.printf("DEVICE MAC address: %s\n", devmac);
        this.connchname = CommonUtils.getConnChannel(devmac);
    }

    protected static byte[] getSelfMac(RedisConfigType type) {
        try {
            HostAndPort hostAndPort = type.getHostAndPort();
            String host = hostAndPort.getHost();
            int port = hostAndPort.getPort();
            if (host.equals("127.0.0.1") || host.equalsIgnoreCase("localhost")) {
                return NetworkUtil.getCurrentMac("www.cnnic.net.cn", 80);
            }
            return NetworkUtil.getCurrentMac(host, port);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void connect() {
        this.subscriber.register(this.ackChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String scanLine(Predicate<String> validate) {
        Scanner scaner = new Scanner(System.in);
        String string = BaseConsole.scanLine(validate, scaner);
        return string;
    }

    private static String scanLine(Predicate<String> validate, Scanner scaner) {
        scaner.reset();
        scaner.useDelimiter("\r?\n");
        while (scaner.hasNextLine()) {
            String str = scaner.next();
            if (str.isEmpty()) {
                return "";
            }
            try {
                if (!validate.apply(str)) continue;
                return str;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return "";
    }

    protected static String inputMac() {
        System.out.println("Input MAC address of Device,such as '00:00:7f:2a:39:4A' or '00e8992730FF':(input empty string if target device demo running on localhost)");
        return BaseConsole.scanLine(new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                String mac = BaseConsole.parseMac(input);
                if (!mac.isEmpty()) {
                    return true;
                }
                System.out.println("ERROR:Invalid mac adress");
                return false;
            }
        });
    }

    private void waitResp(long timestamp) {
        int waitCount = 30;
        TextMessageAdapter adapter = (TextMessageAdapter)this.ackChannel.getAdapter();
        while (adapter.getLastResp() < timestamp && waitCount > 0) {
            try {
                Thread.sleep(100L);
                --waitCount;
            }
            catch (InterruptedException e) {
                System.exit(-1);
            }
        }
        if (waitCount == 0) {
            System.out.println("TIMEOUT for response");
            System.exit(-1);
        }
    }

    private JSONObject makeItemJSON(String path) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(path));
        JSONObject json = new JSONObject();
        if (path.equals("/")) {
            json.fluentPut("path", path).fluentPut("catalog", (Object)ItemType.MENU);
        } else {
            BaseItem item;
            BaseItem currentLevel = Preconditions.checkNotNull(this.renderEngine.getCurrentLevel(), "currentLevel is null");
            if (".".equals(path)) {
                item = currentLevel;
                path = item.getPath();
            } else {
                item = Preconditions.checkNotNull(currentLevel.find(path), "NOT FOUND item %s", (Object)path);
            }
            json.fluentPut("path", path).fluentPut("catalog", (Object)item.getCatalog());
        }
        return json;
    }

    protected <T> boolean syncPublish(Channel<T> channel, T json) {
        try {
            long timestamp = System.currentTimeMillis();
            long rc = this.publisher.publish(channel, json);
            Preconditions.checkState(rc != 0L, "target device DISCONNECT");
            this.waitResp(timestamp);
            return true;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(0);
            return false;
        }
    }

    private boolean syncPublishReq(Object json) {
        Channel<Object> reqCh = new Channel<Object>(Preconditions.checkNotNull(this.reqChannel), Object.class);
        return this.syncPublish(reqCh, json);
    }

    private boolean inputOption(Scanner scaner, final JSONObject json) {
        Preconditions.checkArgument(json != null && ItemType.OPTION == json.getObject("catalog", ItemType.class));
        BaseItem item = this.renderEngine.getCurrentLevel().getChildByPath(json.getString("path"));
        Preconditions.checkArgument(item instanceof BaseOption);
        BaseOption option = (BaseOption)item;
        String desc = Strings.isNullOrEmpty(option.getDescription()) ? "" : "(" + option.getDescription() + ")";
        System.out.printf("INPUT VALUE for %s(%s)%s(input empty for skip):", option.getUiName(), option.getName(), desc);
        String value = BaseConsole.scanLine(new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                if (CommonUtils.isImage(json)) {
                    try {
                        json.fluentPut("value", FaceUtilits.getByteBufferNotEmpty(new File(input)));
                    }
                    catch (Exception e) {
                        Throwables.throwIfUnchecked(e);
                        throw new RuntimeException(e);
                    }
                } else {
                    json.fluentPut("value", input);
                }
                return true;
            }
        }, scaner);
        return !value.isEmpty();
    }

    private boolean inputCmd(Scanner scaner, JSONObject json) {
        Preconditions.checkArgument(json != null && ItemType.CMD == json.getObject("catalog", ItemType.class));
        BaseItem item = this.renderEngine.getCurrentLevel().getChildByPath(json.getString("path"));
        Preconditions.checkArgument(item instanceof CmdItem);
        CmdItem cmd = (CmdItem)item;
        block0: for (BaseOption<Object> param : cmd.getParameters()) {
            JSONObject optjson = this.makeItemJSON(param.getPath());
            while (this.inputOption(scaner, optjson)) {
                if (this.syncPublishReq(optjson)) {
                    Preconditions.checkState(CommonUtils.isAck(this.renderEngine.getLastRespObj()));
                    Ack.Status status = ((JSONObject)this.renderEngine.getLastRespObj()).getObject("status", Ack.Status.class);
                    if (status == Ack.Status.OK) continue block0;
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cmdInteractive() {
        if (!this.syncPublishReq(this.makeItemJSON("/"))) {
            return;
        }
        try (Scanner scaner = new Scanner(System.in);){
            while (scaner.hasNextLine()) {
                String str = scaner.next();
                if (str.isEmpty()) continue;
                try {
                    JSONObject json = this.makeItemJSON(str);
                    switch (json.getObject("catalog", ItemType.class)) {
                        case MENU: {
                            this.syncPublishReq(json);
                            break;
                        }
                        case OPTION: {
                            Ack<?> ack = null;
                            while (this.inputOption(scaner, json)) {
                                this.syncPublishReq(json);
                                ack = this.renderEngine.getLastAck();
                                if (ack != null && !Ack.Status.OK.equals((Object)ack.getStatus())) continue;
                            }
                            this.syncPublishReq(this.makeItemJSON(this.renderEngine.getCurrentLevel().getPath()));
                            break;
                        }
                        case CMD: {
                            if (!this.inputCmd(scaner, json)) break;
                            this.syncPublishReq(json);
                            if (!CommonUtils.isQuit(json, this.renderEngine.getRoot())) break;
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    protected static String parseMac(String input) {
        if ((input = MoreObjects.firstNonNull(input, "").trim()).matches("([\\da-fA-F]{2}:?){6}")) {
            return input.replace(":", "").toLowerCase();
        }
        return "";
    }

    protected void waitTextRenderEngine() {
        int waitCount = 30;
        TextMessageAdapter adapter = (TextMessageAdapter)this.ackChannel.getAdapter();
        while (!(adapter instanceof RenderEngine) && waitCount > 0) {
            try {
                Thread.sleep(100L);
                --waitCount;
            }
            catch (InterruptedException e) {
                System.exit(-1);
            }
        }
        if (waitCount == 0) {
            System.out.println("TIMEOUT for response");
            System.exit(-1);
        }
    }

    public void start() {
        try {
            Channel<String> testch = new Channel<String>(this.connchname, String.class);
            long rc = this.publisher.publish(testch, "\"hello,dtalk\"");
            Preconditions.checkState(rc != 0L, "TARGET DEVICE NOT online");
            if (rc > 1L) {
                System.out.println("WARN:DUPLICATED TARGET DEVICE WITH same MAC address");
            }
            this.connect();
            if (this.authorize()) {
                this.waitTextRenderEngine();
                this.cmdInteractive();
            }
        }
        catch (Exception e) {
            if (this.stackTrace) {
                logger.error(e.getMessage(), e);
            } else {
                System.out.println(e.getMessage());
            }
            return;
        }
    }

    protected abstract boolean authorize();

    public BaseConsole setStackTrace(boolean stackTrace) {
        this.stackTrace = stackTrace;
        return this;
    }
}

