/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.client;

import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import gu.dtalk.ConnectReq;
import gu.dtalk.client.BaseConsole;
import gu.dtalk.client.SampleConsoleConfig;
import gu.dtalk.exception.DtalkException;
import gu.dtalk.redis.DefaultCustomRedisConfigProvider;
import gu.dtalk.redis.RedisConfigType;
import gu.simplemq.Channel;
import gu.simplemq.redis.JedisPoolLazy;
import net.gdface.utils.FaceUtilits;

public class SampleConsole
extends BaseConsole {
    public SampleConsole(String devmac, RedisConfigType config) {
        super(devmac, config);
    }

    @Override
    protected boolean authorize() {
        System.out.println("Input password  of Device,default password is last 4 character of device MAC address(lowercase):");
        ConnectReq req = new ConnectReq();
        req.mac = FaceUtilits.toHex(this.temminalMac);
        Channel<ConnectReq> conch = new Channel<ConnectReq>(this.connchname, ConnectReq.class);
        String pwd = null;
        while (this.reqChannel == null && !(pwd = SampleConsole.scanLine(Predicates.alwaysTrue())).isEmpty()) {
            req.pwd = FaceUtilits.getMD5String(pwd.getBytes());
            this.syncPublish(conch, req);
        }
        if (this.reqChannel != null) {
            System.out.println("PASSWORD validate passed");
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        RedisConfigType config;
        SampleConsoleConfig.CONSOLE_CONFIG.parseCommandLine(args);
        DefaultCustomRedisConfigProvider.initredisParameters(SampleConsoleConfig.CONSOLE_CONFIG.getRedisParameters());
        System.out.println("Text terminal for Device Talk is starting(\u8bbe\u5907\u4ea4\u4e92\u5b57\u7b26\u7ec8\u7aef\u542f\u52a8)");
        String devmac = null;
        if (args.length > 1 && (devmac = SampleConsole.parseMac(args[0])).isEmpty()) {
            System.out.printf("ERROR:Invalid mac adress %s\n", devmac);
            return;
        }
        if (Strings.isNullOrEmpty(devmac)) {
            devmac = SampleConsole.inputMac();
        }
        try {
            config = RedisConfigType.lookupRedisConnect();
        }
        catch (DtalkException e) {
            System.out.println(e.getMessage());
            return;
        }
        logger.info("use config={}", (Object)config.toString());
        JedisPoolLazy.createDefaultInstance(config.readRedisParam());
        SampleConsole client = new SampleConsole(devmac, config);
        client.setStackTrace(SampleConsoleConfig.CONSOLE_CONFIG.isTrace()).start();
    }
}

