/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.Preconditions;
import gu.simplemq.Channel;
import gu.simplemq.Constant;
import gu.simplemq.IPublisher;
import java.util.concurrent.Executor;

public abstract class BasePublishTask<T>
implements Runnable,
Constant {
    private final IPublisher publisher;
    private final Channel<T> channel;
    private final T input;

    public BasePublishTask(Channel<T> channel, T input, IPublisher publisher) {
        this.publisher = Preconditions.checkNotNull(publisher);
        this.channel = Preconditions.checkNotNull(channel);
        this.input = Preconditions.checkNotNull(input);
    }

    @Override
    public void run() {
        try {
            this.publisher.publish(this.channel, this.input);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    public void execute() {
        this.getExecutor().execute(this);
    }

    protected abstract Executor getExecutor();
}

