/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import gu.simplemq.Constant;
import gu.simplemq.IMessageAdapter;
import gu.simplemq.IUnregistedListener;
import gu.simplemq.exceptions.SmqUnsubscribeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class Channel<T>
implements IMessageAdapter<Object>,
Cloneable,
Constant {
    public final String name;
    public final Type type;
    private boolean mutable = true;
    private IMessageAdapter<T> adapter;
    private final LinkedHashSet<IUnregistedListener<T>> unregistedListeners = Sets.newLinkedHashSet();

    public Channel(String name, Class<T> clazz) {
        this(name, (Type)clazz);
    }

    private static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Channel.getRawClass(((ParameterizedType)type).getRawType());
        }
        throw new IllegalArgumentException("invalid type");
    }

    protected Channel(String name) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        this.name = name;
        Type superClass = this.getClass().getGenericSuperclass();
        this.type = Channel.getRawClass(((ParameterizedType)superClass).getActualTypeArguments()[0]);
    }

    protected Channel(String name, IMessageAdapter<T> handle) {
        this(name);
        this.adapter = handle;
    }

    public Channel(String name, Type type) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        this.name = name;
        if (null != null && !(type instanceof ParameterizedType) && !(type instanceof Class)) {
            throw new IllegalArgumentException("invalid type of 'type'");
        }
        this.type = type;
    }

    public Channel(String name, Type type, IMessageAdapter<T> handle) {
        this(name, type);
        this.adapter = handle;
    }

    public Channel(String name, Class<T> clazz, IMessageAdapter<T> handle) {
        this(name, (Type)clazz, handle);
    }

    @Override
    public void onSubscribe(Object t) throws SmqUnsubscribeException {
        if (null == this.adapter || null == t) {
            return;
        }
        try {
            this.adapter.onSubscribe(t);
        }
        catch (SmqUnsubscribeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUnregisted() {
        LinkedHashSet<IUnregistedListener<T>> linkedHashSet = this.unregistedListeners;
        synchronized (linkedHashSet) {
            Iterator itor = this.unregistedListeners.iterator();
            while (itor.hasNext()) {
                IUnregistedListener listener = (IUnregistedListener)itor.next();
                itor.remove();
                listener.apply(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel<T> addUnregistedListener(IUnregistedListener<T> unregistedListener) {
        this.checkMutable();
        LinkedHashSet<IUnregistedListener<T>> linkedHashSet = this.unregistedListeners;
        synchronized (linkedHashSet) {
            this.unregistedListeners.add(Preconditions.checkNotNull(unregistedListener));
        }
        return this;
    }

    public IMessageAdapter<T> getAdapter() {
        return this.adapter;
    }

    public Channel<T> setAdapter(IMessageAdapter<T> adapter) {
        this.checkMutable();
        this.adapter = adapter;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Channel [name=").append(this.name).append(", type=").append(this.type).append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        return Objects.equal(this.name, other.name) && Objects.equal(this.type, other.type);
    }

    public boolean equalsFull(Object obj) {
        return this.equals(obj) && this.adapter == ((Channel)obj).adapter;
    }

    public Channel<T> clone() {
        try {
            return (Channel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Channel<T> immutable() {
        return this.mutable(false);
    }

    private void checkMutable() {
        Preconditions.checkState(this.mutable, "immutable instance can't be modified");
    }

    private Channel<T> mutable(boolean mutable) {
        this.mutable = mutable;
        return this;
    }

    public Channel<T> asMutable() {
        return super.mutable(true);
    }
}

