/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import gu.simplemq.AbstractConsumer;
import gu.simplemq.Constant;
import gu.simplemq.IMessageAdapter;
import gu.simplemq.IQueueComponent;
import gu.simplemq.exceptions.SmqUnsubscribeException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class ConsumerSingle<T>
extends AbstractConsumer
implements IQueueComponent<T> {
    protected BlockingQueue<T> queue = new LinkedBlockingDeque<T>();
    private final Runnable customRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                Object t;
                if (ConsumerSingle.this.isFifo) {
                    t = ConsumerSingle.this.queue.poll(ConsumerSingle.this.timeoutMills, TimeUnit.MILLISECONDS);
                } else if (ConsumerSingle.this.queue instanceof BlockingDeque) {
                    t = ((BlockingDeque)ConsumerSingle.this.queue).pollLast(ConsumerSingle.this.timeoutMills, TimeUnit.MILLISECONDS);
                } else {
                    throw new UnsupportedOperationException(" queue must be instance of  BlockingDeque");
                }
                if (null != t) {
                    try {
                        ConsumerSingle.this.adapter.onSubscribe(t);
                    }
                    catch (SmqUnsubscribeException e) {
                        Constant.logger.info("consumer thread finished because UnsubscribeException");
                        ConsumerSingle.this.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private IMessageAdapter<T> adapter = new IMessageAdapter<T>(){

        @Override
        public void onSubscribe(T t) throws SmqUnsubscribeException {
        }
    };

    public ConsumerSingle() {
    }

    public ConsumerSingle(BlockingQueue<T> queue) {
        this.queue = queue;
    }

    public ConsumerSingle<T> setAdapter(IMessageAdapter<T> adapter) {
        if (null != adapter) {
            this.adapter = adapter;
        }
        return this;
    }

    @Override
    protected Runnable getCustomRunnable() {
        return this.customRunnable;
    }

    @Override
    public BlockingQueue<T> getQueue() {
        return this.queue;
    }

    public ConsumerSingle<T> setQueue(BlockingQueue<T> queue) {
        if (null != queue) {
            this.queue = queue;
        }
        return this;
    }

    @Override
    public String getQueueName() {
        return "unknow";
    }

    @Override
    public void open() {
        super.open();
    }
}

