/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import gu.simplemq.IProducerSingle;
import gu.simplemq.IQueueComponent;
import java.lang.reflect.Type;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;

public class Producer<T>
extends IProducerSingle.AbstractHandler<T>
implements IQueueComponent<T> {
    protected BlockingQueue<T> queue;

    public static final <T> Producer<T> makeInstance(Type type, BlockingQueue<T> queue) {
        return new Producer<T>(type, (BlockingQueue)queue){};
    }

    protected Producer(Class<T> clazz) {
        super(clazz);
    }

    protected Producer(Type type) {
        super(type);
    }

    protected Producer(Class<T> clazz, BlockingQueue<T> queue) {
        this((Type)clazz, queue);
    }

    protected Producer(Type type, BlockingQueue<T> queue) {
        super(type);
        this.queue = queue;
    }

    @Override
    public boolean produce(T t, boolean offerLast) {
        if (!offerLast) {
            if (this.queue instanceof BlockingDeque) {
                return ((BlockingDeque)this.queue).offerFirst(t);
            }
            throw new UnsupportedOperationException(" queue must be instance of  BlockingDeque");
        }
        return this.queue.offer(t);
    }

    @Override
    public boolean produce(T t) {
        if (this.offerLast) {
            return this.queue.offer(t);
        }
        return this.produce(t, this.offerLast);
    }

    @Override
    public BlockingQueue<T> getQueue() {
        return this.queue;
    }

    public Producer<T> setQueue(BlockingQueue<T> queue) {
        this.queue = queue;
        return this;
    }

    @Override
    public String getQueueName() {
        return "unknow";
    }
}

