/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import gu.simplemq.exceptions.SmqNotBeanException;
import gu.simplemq.json.BaseJsonEncoder;
import gu.simplemq.json.ByteBufferCodec;
import gu.simplemq.utils.TypeUtils;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

class FastjsonEncoder
extends BaseJsonEncoder {
    private static final FastjsonEncoder INSTANCE = new FastjsonEncoder();

    public static FastjsonEncoder getInstance() {
        return INSTANCE;
    }

    protected FastjsonEncoder() {
    }

    protected JSONObject doToJSONObject(Object bean) {
        return (JSONObject)JSON.parse(this.toJsonString(bean));
    }

    @Override
    public String toJsonString(Object obj) {
        return JSON.toJSONString(obj, SerializerFeature.WriteMapNullValue);
    }

    @Override
    public Map<String, String> toJsonMap(Object bean) throws SmqNotBeanException {
        if (null == bean) {
            return null;
        }
        if (!TypeUtils.isJavaBean(bean.getClass())) {
            throw new SmqNotBeanException("invalid type,not a java bean object");
        }
        JSONObject jsonObject = this.doToJSONObject(bean);
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {
            Object value = entry.getValue();
            fields.put(entry.getKey(), null == value ? null : this.toJsonString(value));
        }
        return fields;
    }

    @Override
    public <T> T fromJson(String json, Type type) {
        if (type instanceof Class) {
            return JSON.parseObject(json, (Class)type);
        }
        return JSON.parseObject(json, type, new Feature[0]);
    }

    @Override
    public <T> T fromJson(Map<String, String> fieldHash, Type type) throws SmqNotBeanException {
        if (!TypeUtils.isJavaBean(type)) {
            throw new SmqNotBeanException("invalid type,not a java bean");
        }
        if (null == fieldHash || fieldHash.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> entry : fieldHash.entrySet()) {
            fields.put(entry.getKey(), JSON.parse(entry.getValue()));
        }
        return com.alibaba.fastjson.util.TypeUtils.cast(fields, type, null);
    }

    static {
        ParserConfig.global.putDeserializer((Type)((Object)ByteBuffer.class), ByteBufferCodec.instance);
        SerializeConfig.globalInstance.put(ByteBuffer.wrap(new byte[0]).getClass(), ByteBufferCodec.instance);
    }
}

