/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import gu.simplemq.Constant;
import gu.simplemq.redis.JedisUtils;
import java.io.Closeable;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisPoolLazy
implements Constant,
Closeable {
    private static final Set<JedisPoolLazy> POOL_SET = Collections.synchronizedSet(new LinkedHashSet());
    public static final JedisPoolConfig DEFAULT_CONFIG;
    public static final Map<PropName, Object> DEFAULT_PARAMETERS;
    private static volatile JedisPoolLazy defaultInstance;
    private final Map<PropName, Object> parameters;
    private volatile JedisPool pool;
    private static final boolean jmxEnable;
    private final ThreadLocal<AtomicInteger> tlNestCount = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };
    private final ThreadLocal<Jedis> tlJedis = new ThreadLocal();

    public static JedisPoolLazy getDefaultInstance() {
        return null == defaultInstance ? JedisPoolLazy.createDefaultInstance(null) : defaultInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void setDefaultInstance(JedisPoolLazy poolLazy) {
        if (null == defaultInstance) {
            Class<JedisPoolLazy> clazz = JedisPoolLazy.class;
            // MONITORENTER : gu.simplemq.redis.JedisPoolLazy.class
            if (null == defaultInstance) {
                defaultInstance = Preconditions.checkNotNull(poolLazy);
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        }
        logger.warn("INVALID INVOCATION,default instance was initialized already before this invocation");
    }

    public static final JedisPoolLazy createDefaultInstance(Map<PropName, Object> props) {
        JedisPoolLazy.setDefaultInstance(JedisPoolLazy.getInstance(props, true));
        return defaultInstance;
    }

    static JedisPoolLazy createInstance(Map<PropName, Object> props) {
        return new JedisPoolLazy(props);
    }

    public static HashMap<PropName, Object> initParameters(Map<PropName, Object> props) {
        HashMap<PropName, Object> params = Maps.newHashMap(DEFAULT_PARAMETERS);
        if (null != props) {
            Map<PropName, Object> filtered = Maps.filterValues(props, Predicates.notNull());
            params.putAll(filtered);
        }
        return params;
    }

    public static synchronized JedisPoolLazy getInstance(Map<PropName, Object> props, boolean fullMatch) {
        final HashMap<PropName, Object> params = JedisPoolLazy.initParameters(props);
        final URI canonicalURI = JedisUtils.getCanonicalURI(params);
        Optional<JedisPoolLazy> found = fullMatch ? Iterables.tryFind(POOL_SET, new Predicate<JedisPoolLazy>(){

            @Override
            public boolean apply(JedisPoolLazy input) {
                return Objects.equal(canonicalURI, input.getCanonicalURI()) && Objects.equal(params.get((Object)PropName.jedisPoolConfig), input.parameters.get((Object)PropName.jedisPoolConfig)) && Objects.equal(params.get((Object)PropName.timeout), input.parameters.get((Object)PropName.timeout));
            }
        }) : Iterables.tryFind(POOL_SET, new Predicate<JedisPoolLazy>(){

            @Override
            public boolean apply(JedisPoolLazy input) {
                return Objects.equal(canonicalURI, input.getCanonicalURI());
            }
        });
        return found.or(JedisPoolLazy.createInstance(params));
    }

    private static JedisPoolLazy getInstance(JedisPoolConfig jedisPoolConfig, String host, int port, String password, int database, int timeout, URI uri) {
        HashMap<PropName, Object> param = new HashMap<PropName, Object>(DEFAULT_PARAMETERS);
        if (null != jedisPoolConfig) {
            param.put(PropName.jedisPoolConfig, jedisPoolConfig);
        }
        if (null != host && !host.isEmpty()) {
            param.put(PropName.host, host);
        }
        if (0 < port) {
            param.put(PropName.port, port);
        }
        param.put(PropName.password, password);
        if (0 <= database) {
            param.put(PropName.database, database);
        }
        if (0 < timeout) {
            param.put(PropName.timeout, timeout);
        }
        param.put(PropName.uri, uri);
        return JedisPoolLazy.getInstance(param, true);
    }

    public static JedisPoolLazy getInstance(JedisPoolConfig jedisPoolConfig, URI uri, int timeout) {
        if (null == uri) {
            throw new NullPointerException(" the 'uri' must not be null");
        }
        return JedisPoolLazy.getInstance(jedisPoolConfig, null, 0, null, -1, timeout, uri);
    }

    public static JedisPoolLazy getInstance(URI uri) {
        return JedisPoolLazy.getInstance(ImmutableMap.of(PropName.uri, uri), false);
    }

    public static JedisPoolLazy getInstance(JedisPoolConfig jedisPoolConfig, String host, int port, String password, int database, int timeout) {
        return JedisPoolLazy.getInstance(jedisPoolConfig, host, port, password, database, timeout, null);
    }

    public static JedisPoolLazy getInstance(String host, int port, String password, int database) {
        return JedisPoolLazy.getInstance(DEFAULT_CONFIG, host, port, password, database, 2000);
    }

    public static JedisPoolLazy getInstance(String host, int port) {
        return JedisPoolLazy.getInstance(host, port, null, 0);
    }

    public static JedisPoolLazy getInstance(String host) {
        return JedisPoolLazy.getInstance(host, 6379);
    }

    public Map<PropName, Object> getParameters() {
        return new HashMap<PropName, Object>(this.parameters);
    }

    protected JedisPoolLazy(Map<PropName, Object> props) {
        this.parameters = JedisPoolLazy.initParameters(props);
        POOL_SET.add(this);
    }

    public JedisPoolLazy asDefaultInstance() {
        JedisPoolLazy.setDefaultInstance(this);
        return this;
    }

    private JedisPool createPool() {
        int timeout = (Integer)this.parameters.get((Object)PropName.timeout);
        URI uri = this.getCanonicalURI();
        JedisPoolConfig config = (JedisPoolConfig)this.parameters.get((Object)PropName.jedisPoolConfig);
        config.setJmxEnabled(jmxEnable);
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)config, uri, timeout);
        logger.info("jedis pool initialized(\u8fde\u63a5\u6c60\u521d\u59cb\u5316)  {} timeout : {} ms", (Object)uri, (Object)timeout);
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Jedis getJedis() {
        if (null == this.pool) {
            JedisPoolLazy jedisPoolLazy = this;
            synchronized (jedisPoolLazy) {
                if (null == this.pool) {
                    this.pool = this.createPool();
                }
            }
        }
        return this.pool.getResource();
    }

    public void releaseJedis(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    public Jedis apply() {
        Jedis jedis = this.tlJedis.get();
        if (null == jedis) {
            jedis = this.getJedis();
            this.tlJedis.set(jedis);
        }
        this.tlNestCount.get().incrementAndGet();
        return jedis;
    }

    public void free() {
        Jedis jedis = this.tlJedis.get();
        if (null == jedis) {
            throw new IllegalStateException("apply/free mismatch");
        }
        if (0 == this.tlNestCount.get().decrementAndGet()) {
            this.releaseJedis(jedis);
            this.tlJedis.remove();
            this.tlNestCount.remove();
        }
    }

    public URI getCanonicalURI() {
        return JedisUtils.getCanonicalURI(this.parameters);
    }

    private static boolean isJmxEnable() {
        try {
            Class.forName("java.lang.management.ManagementFactory");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@");
        builder.append(this.hashCode());
        builder.append("[URI=");
        builder.append(this.getCanonicalURI());
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JedisPoolLazy)) {
            return false;
        }
        JedisPoolLazy other = (JedisPoolLazy)obj;
        return this.getCanonicalURI().equals(other.getCanonicalURI());
    }

    @Override
    public void close() {
        if (this.pool != null) {
            this.pool.close();
            logger.info("discard jedis pool: {}", (Object)this);
            this.pool = null;
        }
    }

    public static synchronized void closeAll() {
        Iterator<JedisPoolLazy> itor = POOL_SET.iterator();
        while (itor.hasNext()) {
            JedisPoolLazy p = itor.next();
            itor.remove();
            p.close();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                JedisPoolLazy.closeAll();
            }
        });
        DEFAULT_CONFIG = new JedisPoolConfig(){
            {
                this.setMaxTotal(Runtime.getRuntime().availableProcessors());
            }
        };
        DEFAULT_PARAMETERS = Collections.unmodifiableMap(new HashMap<PropName, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(PropName.jedisPoolConfig, DEFAULT_CONFIG);
                this.put(PropName.host, "localhost");
                this.put(PropName.port, 6379);
                this.put(PropName.password, null);
                this.put(PropName.database, 0);
                this.put(PropName.timeout, 2000);
            }
        });
        jmxEnable = JedisPoolLazy.isJmxEnable();
    }

    public static enum PropName {
        jedisPoolConfig,
        host,
        port,
        password,
        database,
        timeout,
        uri;

    }
}

