/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import gu.simplemq.redis.JedisPoolLazy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import redis.clients.jedis.Jedis;
import redis.clients.util.JedisURIHelper;

public class JedisUtils {
    private JedisUtils() {
    }

    public static URI createJedisURI(String scheme, String host, Integer port, String password, Integer database) {
        String userInfo = null;
        if (!Strings.isNullOrEmpty(password)) {
            userInfo = ":" + password;
        }
        try {
            return new URI(MoreObjects.firstNonNull(scheme, "jedis"), userInfo, MoreObjects.firstNonNull(host, "localhost"), MoreObjects.firstNonNull(port, 6379), "/" + MoreObjects.firstNonNull(database, 0), null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI createJedisURI(String host, Integer port, String password, Integer database) {
        return JedisUtils.createJedisURI("jedis", host, port, password, database);
    }

    public static URI getCanonicalURI(Map<JedisPoolLazy.PropName, Object> parameters) {
        URI uri = (URI)(parameters = JedisPoolLazy.initParameters(parameters)).get((Object)JedisPoolLazy.PropName.uri);
        if (null == uri) {
            uri = JedisUtils.createJedisURI((String)parameters.get((Object)JedisPoolLazy.PropName.host), ((Number)parameters.get((Object)JedisPoolLazy.PropName.port)).intValue(), (String)parameters.get((Object)JedisPoolLazy.PropName.password), ((Number)parameters.get((Object)JedisPoolLazy.PropName.database)).intValue());
        } else {
            try {
                uri = new URI("jedis", uri.getUserInfo(), JedisUtils.convertHost(uri.getHost()), uri.getPort(), "/" + JedisURIHelper.getDBIndex(uri), null, null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runOnRedis(Function<Jedis, T> fun, JedisPoolLazy poolLazy) {
        if (null == fun) {
            return null;
        }
        Jedis jedis = poolLazy.apply();
        try {
            T t = fun.apply(jedis);
            return t;
        }
        finally {
            poolLazy.free();
        }
    }

    public static <T> T runOnRedis(Function<Jedis, T> fun) {
        return JedisUtils.runOnRedis(fun, JedisPoolLazy.getDefaultInstance());
    }

    private static String convertHost(String host) {
        if ("127.0.0.1".equals(host)) {
            return "localhost";
        }
        if ("::1".equals(host)) {
            return "localhost";
        }
        return host;
    }

    public static String setnx(final String key, final String value) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key) && !Strings.isNullOrEmpty(value), "key or value is null or empty");
        return JedisUtils.runOnRedis(new Function<Jedis, String>(){

            @Override
            public String apply(Jedis input) {
                input.setnx(key, value);
                return input.get(key);
            }
        });
    }

    public static String get(final String key) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        return JedisUtils.runOnRedis(new Function<Jedis, String>(){

            @Override
            public String apply(Jedis input) {
                return input.get(key);
            }
        });
    }

    public static long incr(final String key) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        return JedisUtils.runOnRedis(new Function<Jedis, Long>(){

            @Override
            public Long apply(Jedis input) {
                return input.incr(key);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testConnect(Map<JedisPoolLazy.PropName, Object> props) {
        props = JedisPoolLazy.initParameters(props);
        try (Jedis jedis = new Jedis((String)props.get((Object)JedisPoolLazy.PropName.host), ((Number)props.get((Object)JedisPoolLazy.PropName.port)).intValue(), ((Number)props.get((Object)JedisPoolLazy.PropName.timeout)).intValue(), ((Number)props.get((Object)JedisPoolLazy.PropName.timeout)).intValue());){
            int database;
            jedis.connect();
            String password = (String)props.get((Object)JedisPoolLazy.PropName.password);
            if (null != password) {
                jedis.auth(password);
            }
            if ((database = ((Integer)props.get((Object)JedisPoolLazy.PropName.database)).intValue()) != 0) {
                jedis.select(database);
            }
            boolean bl = true;
            return bl;
        }
    }
}

