/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.reflect.TypeToken;
import gu.simplemq.Channel;
import gu.simplemq.IProducer;
import gu.simplemq.json.BaseJsonEncoder;
import gu.simplemq.redis.IRedisComponent;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.utils.CommonUtils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import redis.clients.jedis.Jedis;

public class RedisProducer
implements IRedisComponent,
IProducer {
    protected boolean offerLast = true;
    private BaseJsonEncoder encoder = BaseJsonEncoder.getEncoder();
    private final JedisPoolLazy poolLazy;

    @Override
    public JedisPoolLazy getPoolLazy() {
        return this.poolLazy;
    }

    public RedisProducer(JedisPoolLazy poolLazy) {
        this.poolLazy = poolLazy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void produce(Channel<T> channel, T object, boolean offerLast) {
        if (null == object) {
            return;
        }
        Jedis jedis = this.poolLazy.apply();
        try {
            if (offerLast) {
                jedis.rpush(channel.name, this.encoder.toJsonString(object));
            } else {
                jedis.lpush(channel.name, this.encoder.toJsonString(object));
            }
        }
        finally {
            this.poolLazy.free();
        }
    }

    @Override
    public <T> void produce(Channel<T> channel, T object) {
        this.produce(channel, object, this.offerLast);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void produce(Channel<T> channel, boolean offerLast, T ... objects) {
        List<T> list = CommonUtils.cleanNullAsList(objects);
        if (list.isEmpty()) {
            return;
        }
        if (null != channel.type && channel.type instanceof Class && !((Class)channel.type).isAssignableFrom(objects.getClass().getComponentType())) {
            throw new IllegalArgumentException("invalid component type of 'objects'");
        }
        String[] strings = new String[list.size()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = this.encoder.toJsonString(list.get(i));
        }
        Jedis jedis = this.poolLazy.apply();
        try {
            if (offerLast) {
                jedis.rpush(channel.name, strings);
            } else {
                jedis.lpush(channel.name, strings);
            }
        }
        finally {
            this.poolLazy.free();
        }
    }

    @Override
    public <T> void produce(Channel<T> channel, T ... objects) {
        this.produce(channel, this.offerLast, objects);
    }

    @Override
    public <T> void produce(Channel<T> channel, boolean offerLast, Collection<T> c) {
        if (null != c) {
            this.produce(channel, offerLast, c.toArray((Object[])Array.newInstance(TypeToken.of(channel.type).getRawType(), 0)));
        }
    }

    @Override
    public <T> void produce(Channel<T> channel, Collection<T> c) {
        this.produce(channel, this.offerLast, c);
    }

    @Override
    public void setOfferLast(boolean offerLast) {
        this.offerLast = offerLast;
    }
}

