/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gu.simplemq.AbstractSubcriber;
import gu.simplemq.Constant;
import gu.simplemq.IMessageDispatcher;
import gu.simplemq.exceptions.SmqTypeException;
import gu.simplemq.redis.IRedisComponent;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.RedisComponentType;
import gu.simplemq.redis.RedisSubHandle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisSubscriber
extends AbstractSubcriber
implements IRedisComponent {
    private final JedisPoolLazy pool;
    private final RedisSubHandle jedisPubSub = new RedisSubHandle(this);
    private static final ExecutorService subscribeExecutor = MoreExecutors.getExitingExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("stp-subscribe-%d").build()));
    private volatile Jedis jedis = null;

    @Override
    public JedisPoolLazy getPoolLazy() {
        return this.pool;
    }

    RedisSubscriber(JedisPoolLazy poolLazy) {
        this.pool = poolLazy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSubscribe(String ... channels) {
        RedisSubscriber redisSubscriber = this;
        synchronized (redisSubscriber) {
            try {
                this.jedisPubSub.subscribe(channels);
            }
            catch (JedisConnectionException e) {
                this.open(channels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUnsubscribe(String ... channels) {
        RedisSubscriber redisSubscriber = this;
        synchronized (redisSubscriber) {
            if (this.jedisPubSub.isSubscribed()) {
                this.jedisPubSub.unsubscribe(channels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jedis getJedis() {
        if (null == this.jedis) {
            RedisSubscriber redisSubscriber = this;
            synchronized (redisSubscriber) {
                if (null == this.jedis) {
                    this.jedis = this.pool.getJedis();
                }
            }
        }
        return this.jedis;
    }

    private void open(final String ... channels) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    RedisSubscriber.this.getJedis().subscribe(RedisSubscriber.this.jedisPubSub, channels);
                }
                catch (Exception e) {
                    Constant.logger.error("Subscribing failed.", e);
                }
            }
        };
        subscribeExecutor.execute(run);
    }

    public RedisSubscriber setDispatcher(IMessageDispatcher dispatcher) {
        this.jedisPubSub.setDispatcher(dispatcher);
        return this;
    }

    @Override
    protected String check(String name) throws SmqTypeException {
        return RedisComponentType.Channel.check(this.pool, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        if (this.jedis != null) {
            RedisSubscriber redisSubscriber = this;
            synchronized (redisSubscriber) {
                if (this.jedis != null) {
                    this.pool.releaseJedis(this.jedis);
                    this.jedis = null;
                }
            }
        }
    }
}

