/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.base.Strings;
import gu.simplemq.redis.IRedisComponent;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.RedisComponentType;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class TablenameChecker
implements IRedisComponent {
    private static final ConcurrentMap<JedisPoolLazy, TablenameChecker> CHECKERS = new ConcurrentHashMap<JedisPoolLazy, TablenameChecker>();
    private final JedisPoolLazy poolLazy;
    private final ConcurrentMap<String, Type> nameTypes = new ConcurrentHashMap<String, Type>();

    public static TablenameChecker getNameChecker(JedisPoolLazy poolLazy) {
        TablenameChecker checker = (TablenameChecker)CHECKERS.get(poolLazy);
        if (null == checker) {
            CHECKERS.putIfAbsent(poolLazy, new TablenameChecker(poolLazy));
            checker = (TablenameChecker)CHECKERS.get(poolLazy);
        }
        return checker;
    }

    protected TablenameChecker(JedisPoolLazy poolLazy) {
        this.poolLazy = poolLazy;
    }

    public String check(String name, RedisComponentType componentType, Type type) {
        if (Strings.isNullOrEmpty(name) || null == componentType || null == type) {
            throw new IllegalArgumentException("the arguments must not be null or empty");
        }
        componentType.check(this.poolLazy, name);
        Type old = this.nameTypes.putIfAbsent(name, type);
        if (null != old && old != type) {
            throw new IllegalStateException(String.format("the '%s' can't be used for %s,because it be used for %s", name, type.toString(), old.toString()));
        }
        return name;
    }

    @Override
    public JedisPoolLazy getPoolLazy() {
        return this.poolLazy;
    }
}

